package ru.yandex.autotests.direct.api.campaigns.update.fieldvalidation;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.CampOptions.CAMP_OPTIONS;

@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка обновления поля ClientInfo")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateClientInfoTest {
    private static final String CLIENT = CampaignsLogins.UPDATE_CLIENT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long id;
    private static Long idEmpty;
    private static Long idInvalid;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String clientInfo;

    @Parameterized.Parameter(2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Валидный", "Valid", JavaOrPerlExpectedResult.both(ExpectedResult.success())},
                {"Невалидный", "<Invalid2>", JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetailsJava.INVALID_CHARS, "ClientInfo")))
                        .perl(ExpectedResult.errors(new Notification(5002,
                                Api5ErrorDetails.CLIENT_NAME_CONTAINS_SPECIAL_CHARACTERS)))
                },
                {"Пустой", "", JavaOrPerlExpectedResult.both(ExpectedResult.success())},
                {"Не указываем", null, JavaOrPerlExpectedResult.both(ExpectedResult.success())},
        });
    }

    @BeforeClass
    public static void createCampaigns() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();

        idEmpty = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).campaignsSteps()
                .setCampaignOption(idEmpty, CAMP_OPTIONS.FIO, "");

        idInvalid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).campaignsSteps()
                .setCampaignOption(idInvalid, CAMP_OPTIONS.FIO, "<Invalid>");
    }

    @Test
    public void updateValidClientInfo() {
        CampaignUpdateItemMap campaign = new CampaignUpdateItemMap().withId(id);
        if (clientInfo != null) {
            campaign.withClientInfo(clientInfo);
        }

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withCampaigns(campaign),
                expectedResult);
    }

    @Test
    public void updateInvalidClientInfo() {
        CampaignUpdateItemMap campaign = new CampaignUpdateItemMap().withId(idInvalid);
        if (clientInfo != null) {
            campaign.withClientInfo(clientInfo);
        }

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withCampaigns(campaign),
                expectedResult);
    }

    @Test
    public void updateEmptyClientInfo() {
        CampaignUpdateItemMap campaign = new CampaignUpdateItemMap().withId(idEmpty);
        if (clientInfo != null) {
            campaign.withClientInfo(clientInfo);
        }

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withCampaigns(campaign),
                expectedResult);
    }
}
