package ru.yandex.autotests.direct.api.campaigns.update.fieldvalidation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.apache.commons.lang3.StringUtils.uncapitalize;

/**
 * Created by ginger on 21.08.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34570")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка обновления невалидного поля ExcludedSites")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateExcludedSitesNegativeTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;
    private static final String SSP_PLATFORM = "Rubicon";
    private static final String SSP_PLATFORM_RANDOM_CASE = "rUBiCon";
    private static final String APP_ID_IN_ONE_PART = "rut-r-o-njc_DreamBook_FREE123";
    private static final String APP_ID_STARTS_WITH_NUMBER = "1ru.t-r-o-n.jc_DreamBook_FREE123";
    private static final String APP_ID_IN_ONE_PARENTHESES = "ru.(t-r-o-n).jc_DreamBook_FREE123";
    private static final String APP_ID_WITH_CYRILIC = "ru.t-r-o-n.бах.jc_DreamBook_FREE";
    private static Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String[] excludedSites;

    @Parameterized.Parameter(2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        List<String> overLengthExcludedSites = new ArrayList<String>();
        for (int i = 0; i < CampaignAddItemMap.MAX_AMOUNT_OF_EXCLUDED_SITES + 1; i++) {
            overLengthExcludedSites.add(RandomStringUtils.randomAlphabetic(10).toLowerCase() + ".ru");
        }
        List<String> overLengthExcludedSitesWithSspPlatform = overLengthExcludedSites;
        overLengthExcludedSitesWithSspPlatform.set(0, SSP_PLATFORM);

        Object[][] data = new Object[][]{
                {"spb.ru", new String[]{"spb.ru"}, JavaOrPerlExpectedResult
                        .java(ExpectedResult.errorsIgnoringDetails(new Notification(5006)))
                        .perl(ExpectedResult.errors(new Notification(5006,
                                Api5ErrorDetails.YOU_CAN_BLOCK_ONLY_THIRD_LEVEL, "spb.ru")))},
                {"ya.ru", new String[]{"ya.ru"}, JavaOrPerlExpectedResult
                        .java(ExpectedResult.errorsIgnoringDetails(new Notification(5006)))
                        .perl(ExpectedResult.errors(new Notification(5006,
                                Api5ErrorDetails.IMPRESSIONS_ON_SITE_CANNOT_BE_DISABLED, "ya.ru")))},
                {"yandex.ru", new String[]{"yandex.ru"}, JavaOrPerlExpectedResult
                        .java(ExpectedResult.errorsIgnoringDetails(new Notification(5006)))
                        .perl(ExpectedResult.errors(new Notification(5006,
                                Api5ErrorDetails.IMPRESSIONS_ON_SITE_CANNOT_BE_DISABLED, "yandex.ru")))},
                {"someString", new String[]{"someString"}, JavaOrPerlExpectedResult
                        .java(ExpectedResult.errorsIgnoringDetails(new Notification(5006)))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_DOMAIN_FORMAT, "someString")))},
                {"emptyString", new String[]{""}, JavaOrPerlExpectedResult
                        .java(ExpectedResult.errorsIgnoringDetails(new Notification(5006)))
                        .perl(ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.ELEMENT_OF_ARRAY_CANT_BE_EMPTY_STRING,
                                capitalize(CampaignAddItemMap.EXCLUDED_SITES))))},
                {"space", new String[]{" "}, JavaOrPerlExpectedResult
                        .java(ExpectedResult.errorsIgnoringDetails(new Notification(5006)))
                        .perl(ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.ELEMENT_OF_ARRAY_CANT_BE_EMPTY_STRING,
                                capitalize(CampaignAddItemMap.EXCLUDED_SITES))))},
                {"1234.56", new String[]{"1234.56"}, JavaOrPerlExpectedResult
                        .java(ExpectedResult.errorsIgnoringDetails(new Notification(5006)))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_DOMAIN_FORMAT, "1234.56")))},
                {"http://qwerty.ru", new String[]{"http://qwerty.ru"}, JavaOrPerlExpectedResult
                        // java обрежет 'http' и запишет просто qwerty.ru
                        .java(ExpectedResult.success())
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_DOMAIN_FORMAT, "http://qwerty.ru")))},
                {"повторяющееся значение", new String[]{"qwerty.ru", "qwerty.ru"}, JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(9802,
                                Api5ErrorDetailsJava.ELEMENT_PRESENT_IN_LIST_MORE_THAN_ONE_TIME_WITHOUT_LIST,
                                "qwerty.ru")))
                        .perl(ExpectedResult.errors(new Notification(9802,
                                Api5ErrorDetails.ELEMENT_PRESENT_IN_LIST_MORE_THAN_ONE_TIME,
                                "qwerty.ru", capitalize(CampaignAddItemMap.EXCLUDED_SITES))))},
                {"повторяющееся значение площадки", new String[]{SSP_PLATFORM, SSP_PLATFORM}, JavaOrPerlExpectedResult
                                // java в отличие от перла убирает дубли, вместо того, чтобы выдавать ошибку
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.errorsIgnoringDetails(
                                    new Notification(9802,
                                        Api5ErrorDetails.ELEMENT_PRESENT_IN_LIST_MORE_THAN_ONE_TIME,
                                        uncapitalize(SSP_PLATFORM), capitalize(CampaignAddItemMap.EXCLUDED_SITES))))},
                {"повторяющееся значение площадки разных регистров",
                        new String[]{SSP_PLATFORM_RANDOM_CASE, SSP_PLATFORM}, JavaOrPerlExpectedResult
                                .java(ExpectedResult.success()) // и игнорирует регистр
                                .perl(ExpectedResult.errorsIgnoringDetails(
                                    new Notification(9802,
                                        Api5ErrorDetails.ELEMENT_PRESENT_IN_LIST_MORE_THAN_ONE_TIME,
                                        uncapitalize(SSP_PLATFORM), capitalize(CampaignAddItemMap.EXCLUDED_SITES))))},
                {"значение с пробелом", new String[]{"qwe rty.ru"}, JavaOrPerlExpectedResult
                        .java(ExpectedResult.errorsIgnoringDetails(new Notification(5006)))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_DOMAIN_FORMAT,
                        "qwe", capitalize(CampaignAddItemMap.EXCLUDED_SITES))))},
                {"Количество доменов, превышающее максимальную длину", overLengthExcludedSites.toArray(new String[]{}),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errorsIgnoringDetails(new Notification(7001)))
                                .perl(ExpectedResult.errors(new Notification(7001,
                                        Api5ErrorDetails.NUMBER_OF_DISABLED_SITES_EXCEEDS_ITS_LIMIT,
                                        CampaignAddItemMap.MAX_AMOUNT_OF_EXCLUDED_SITES)))},
                {"Количество доменов и ssp площадок, превышающее максимальную длину",
                        overLengthExcludedSitesWithSspPlatform.toArray(new String[]{}),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errorsIgnoringDetails(new Notification(7001)))
                                .perl(ExpectedResult.errors(new Notification(7001,
                                        Api5ErrorDetails.NUMBER_OF_DISABLED_SITES_EXCEEDS_ITS_LIMIT,
                                        CampaignAddItemMap.MAX_AMOUNT_OF_EXCLUDED_SITES)))},
                {"ID приложения, состоящее из одного уровня домена " + APP_ID_IN_ONE_PART,
                        new String[]{APP_ID_IN_ONE_PART}, JavaOrPerlExpectedResult
                                .java(ExpectedResult.errorsIgnoringDetails(new Notification(5006)))
                                .perl(ExpectedResult.errors(new Notification(5004,
                                        Api5ErrorDetails.INVALID_DOMAIN_FORMAT, APP_ID_IN_ONE_PART)))},
                {"ID приложения, начинающееся с цифры " + APP_ID_STARTS_WITH_NUMBER,
                        new String[]{APP_ID_STARTS_WITH_NUMBER}, JavaOrPerlExpectedResult
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.errors(new Notification(5004,
                                        Api5ErrorDetails.INVALID_DOMAIN_FORMAT, APP_ID_STARTS_WITH_NUMBER)))},
                {"ID приложения, содержащее скобки " + APP_ID_IN_ONE_PARENTHESES,
                        new String[]{APP_ID_IN_ONE_PARENTHESES}, JavaOrPerlExpectedResult
                                .java(ExpectedResult.errorsIgnoringDetails(new Notification(5006)))
                                .perl(ExpectedResult.errors(new Notification(5004,
                                        Api5ErrorDetails.INVALID_DOMAIN_FORMAT, APP_ID_IN_ONE_PARENTHESES)))},
                {"ID приложения, содержащее кириллицу " + APP_ID_WITH_CYRILIC, new String[]{APP_ID_WITH_CYRILIC},
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_DOMAIN_FORMAT, APP_ID_WITH_CYRILIC)))}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.getDirectJooqDbSteps().sspPlatformsSteps().saveSspPlatformsIfNotExist(SSP_PLATFORM);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1011")
    public void tryUpdateExcludedSites() {
        //DIRECT-46047
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withExcludedSites(excludedSites)
                        ),
                expectedResult);
    }
}
