package ru.yandex.autotests.direct.api.campaigns.update.fieldvalidation;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 22.03.16. * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-52067")
@Features(CampaignsFeatures.UPDATE)
@Description("Регистронезависимость SSP площадок в поле ExcludedSites")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateExcludedSitesRegisterSensitiveTest {
    private static String client = CampaignsLogins.UPDATE_CLIENT;
    private static final String SSP_PLATFORM_DEFAULT = "Rubicon";
    private static final String SSP_PLATFORM_UPPER_CASE = SSP_PLATFORM_DEFAULT.toUpperCase();
    private static final String SSP_PLATFORM_LOWER_CASE = SSP_PLATFORM_DEFAULT.toLowerCase();
    private static final String SSP_PLATFORM_RANDOM_CASE = "rUBiCon";
    private static Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String excludedSites;

    @Parameterized.Parameters(name = "SSP площадка: {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {SSP_PLATFORM_DEFAULT},
                {SSP_PLATFORM_UPPER_CASE},
                {SSP_PLATFORM_LOWER_CASE},
                {SSP_PLATFORM_RANDOM_CASE}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.getDirectJooqDbSteps().sspPlatformsSteps().saveSspPlatformsIfNotExist(SSP_PLATFORM_DEFAULT);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1012")
    public void updateExcludedSites() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withExcludedSites(excludedSites)
                        ),
                ExpectedResult.success(id));
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(id, CampaignFieldEnum.EXCLUDED_SITES);
        assertThat("поле ExcludedSItes сохранилось верно", campaignGetItem,
                beanDifferV5((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withExcludedSites(SSP_PLATFORM_DEFAULT).getBean()));
    }
}
