package ru.yandex.autotests.direct.api.campaigns.update.fieldvalidation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 21.08.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34570")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка обновления поля ExcludedSites")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateExcludedSitesTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;
    private static final String DOMAIN = "Qwerty.ru";
    private static final String DOMAIN_CYRILIC = "яндекс.ру";
    private static final String SSP_PLATFORM = "Rubicon";
    private static final String SSP_PLATFORM_WITH_SPACE = "Smaato (test)";
    private static final String SSP_PLATFORM_DOMAIN_FORMAT = "sspplatform.ru";
    private static final String APP_ID_WITH_HYPHEN_UNDERSCORE_DOT_NUMBER = "ru.t-r-o-n.jc_DreamBook_FREE123";
    private static Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String[] excludedSites;

    @Parameterized.Parameter(2)
    public String[] expectedExcludedSites;

    @Parameterized.Parameter(3)
    public ProtocolType protocolType;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        List<String> maxLengthExcludedSites = new ArrayList<String>();
        for (int i = 0; i < CampaignAddItemMap.MAX_AMOUNT_OF_EXCLUDED_SITES; i++) {
            maxLengthExcludedSites.add(RandomStringUtils.randomAlphabetic(10).toLowerCase() + ".ru");
        }
        Collections.sort(maxLengthExcludedSites);

        List<String> maxLengthExcludedSitesWithSspPlatform = new ArrayList<>(maxLengthExcludedSites);
        maxLengthExcludedSitesWithSspPlatform
                .set(CampaignAddItemMap.MAX_AMOUNT_OF_EXCLUDED_SITES - 1, SSP_PLATFORM_DOMAIN_FORMAT);
        Object[][] data = new Object[][]{
                {"Домен " + DOMAIN, new String[]{DOMAIN}, new String[]{DOMAIN.toLowerCase()}, ProtocolType.JSON},
                {"Домен с кириллицей " + DOMAIN_CYRILIC, new String[]{DOMAIN_CYRILIC},
                        new String[]{DOMAIN_CYRILIC.toLowerCase()}, ProtocolType.JSON},
                {"SSP площадка " + SSP_PLATFORM, new String[]{SSP_PLATFORM}, new String[]{SSP_PLATFORM},
                        ProtocolType.JSON},
                {"SSP площадка с пробелом " + SSP_PLATFORM_WITH_SPACE, new String[]{SSP_PLATFORM_WITH_SPACE},
                        new String[]{SSP_PLATFORM_WITH_SPACE}, ProtocolType.JSON},
                {"Максимальное количество доменов", maxLengthExcludedSites.toArray(new String[]{}),
                        maxLengthExcludedSites.toArray(new String[]{}), ProtocolType.JSON},
                {"Максимальное количество доменов и ssp площадок",
                        maxLengthExcludedSitesWithSspPlatform.toArray(new String[]{}),
                        maxLengthExcludedSitesWithSspPlatform.toArray(new String[]{}), ProtocolType.JSON},
                {"ID приложения c тире, прочеркиванием, точкой и цифрами" + APP_ID_WITH_HYPHEN_UNDERSCORE_DOT_NUMBER,
                        new String[]{APP_ID_WITH_HYPHEN_UNDERSCORE_DOT_NUMBER},
                        new String[]{APP_ID_WITH_HYPHEN_UNDERSCORE_DOT_NUMBER.toLowerCase()}, ProtocolType.JSON},
                {"null JSON", null, null, ProtocolType.JSON},
                {"null SOAP", null, null, ProtocolType.SOAP}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps();
        jooqDbSteps.sspPlatformsSteps().saveSspPlatformsIfNotExist(SSP_PLATFORM);
        jooqDbSteps.sspPlatformsSteps().saveSspPlatformsIfNotExist(SSP_PLATFORM_WITH_SPACE);
        jooqDbSteps.sspPlatformsSteps().saveSspPlatformsIfNotExist(SSP_PLATFORM_DOMAIN_FORMAT);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1013")
    public void updateExcludedSites() {
        api.protocol(protocolType);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withExcludedSites(excludedSites)
                        ),
                ExpectedResult.success(id));
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(id, CampaignFieldEnum.EXCLUDED_SITES);
        assertThat("поле ExcludedSItes сохранилось верно", campaignGetItem,
                beanDifferV5((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withExcludedSites(expectedExcludedSites).getBean()));
    }
}
