package ru.yandex.autotests.direct.api.campaigns.update.fieldvalidation;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 21.08.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34570")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка невалидного обновления поля Name")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateNameNegativeTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;

    private static Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String name;

    @Parameterized.Parameter(2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        String maxLengthName = RandomStringUtils.randomAlphabetic(CampaignAddItemMap.MAX_NAME_LENGTH);
        return Arrays.asList(new Object[][]{
                {"Пустая строка", "",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(
                                        5003, Api5ErrorDetailsJava.EMPTY_VALUE, "Name")))
                                .perl(ExpectedResult.errors(new Notification(
                                5003, Api5ErrorDetails.CAMPAIGN_NAME_IS_EMPTY)))},
                {"Только пробел", " ",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(
                                        5003, Api5ErrorDetailsJava.EMPTY_VALUE, "Name")))
                                .perl(ExpectedResult.errors(new Notification(
                                5003, Api5ErrorDetails.CAMPAIGN_NAME_IS_EMPTY)))},
                {"Тег", "</Name>",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(
                                        5002, Api5ErrorDetailsJava.INVALID_CHARS, "Name")))
                                .perl(ExpectedResult.errors(new Notification(
                                5002, Api5ErrorDetails.CAMPAIGNS_NAME_CONTAINS_SPECIAL_CHARACTERS)))},
                {"Имя длиннее максимальной длины", maxLengthName + "f",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(
                                        5001, Api5ErrorDetailsJava.MAX_STR_LENGTH, "Name",
                                        CampaignAddItemMap.MAX_NAME_LENGTH)))
                                .perl(ExpectedResult.errors(new Notification(
                                5001, Api5ErrorDetails.CAMPAIGN_NAME_LENGTH_EXCEEDED,
                                CampaignAddItemMap.MAX_NAME_LENGTH)))},
        });
    }

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1014")
    public void tryUpdateInvalidName() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withName(name)
                        ),
                expectedResult);
    }
}
