package ru.yandex.autotests.direct.api.campaigns.update.fieldvalidation;

import java.util.Arrays;
import java.util.Collection;

import org.joda.time.DateTime;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 21.08.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34570")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка невалидного обновления поля StartDate")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateStartDateNegativeTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String startDate;

    @Parameterized.Parameter(2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Пустая строка", "",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(
                                        5003, Api5ErrorDetailsJava.EMPTY_VALUE, "StartDate")))
                                .perl(ExpectedResult.errors(new Notification(
                                5003, Api5ErrorDetails.EMPTY_START_DATE)))
                },
                {"Строка", "дата",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(5004,
                                        Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                                .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)))
                },
                {"Неправильный формат", DateTime.now().toString("dd-MM-yyyy"),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(5004,
                                        Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                                .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)))
                },
                {"0000-00-00", "0000-00-00",
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(5004,
                                        Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                                .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)))
                }
        });
    }

    private static Long id;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1018")
    public void updateWithStartDate() {
        //DIRECT-45510
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withStartDate(startDate)),
                expectedResult);
    }
}
