package ru.yandex.autotests.direct.api.campaigns.update.mobilecampaign;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsAttributionModel;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pashkus on 5.09.19.
 * https://st.yandex-team.ru/DIRECT-99821
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-99821")
@Features(CampaignsFeatures.ADD)
@Description("Проверка поля AttributionModel в БД")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AttributionModelDbTest {
    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static int shard;
    private Long campaignId;

    @Parameterized.Parameter()
    public CampaignsAttributionModel attributionModelDbValue;

    @Parameterized.Parameters(name = "campaigns.attribution_model = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {CampaignsAttributionModel.last_significant_click},
                {null},
        };
        return Arrays.asList(data);
    }


    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
    }

    @Before
    public void prepare() {
        campaignId = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDefaultMobileAppCampaign());

        //Устанавливаем значение, отличное от значеня по-умолчанию
        CampaignsRecord campaignsRecord =  api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .getCampaignById(campaignId);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().updateCampaigns(
                campaignsRecord.setAttributionModel(attributionModelDbValue)
        );
    }

    @Test
    public void checkImmutabilityOfAttributionModelDbValue() {

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(campaignId)
                                .withMobileAppCampaign(new MobileAppCampaignUpdateItemMap()
                                        .withSettings(new MobileAppCampaignSettingMap()
                                                .withOption(MobileAppCampaignSettingsEnum.ADD_TO_FAVORITES)
                                                .withValue(YesNoEnum.YES)))),
                ExpectedResult.success(campaignId));

        assertThat("campaigns.attribution_model соответсвует ожиданиям",
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                        .getCampaignById(campaignId).getAttributionModel(),
                equalTo((attributionModelDbValue != null) ? attributionModelDbValue :
                        CampaignsAttributionModel.last_yandex_direct_click_cross_device));
    }
}
