package ru.yandex.autotests.direct.api.campaigns.update.mobilecampaign;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsMobileContentRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MobileAppsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.direct.db.steps.MobileAppSteps.getDefaultMobileAppsRecord;
import static ru.yandex.autotests.directapi.darkside.model.MobileContentUtils.getDefaultMobileContent;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Поверка таблицы campaigns_mobile_content после обновления кампании new РМП")
@Issue("https://st.yandex-team.ru/DIRECT-83672")
@Tag(TagDictionary.TRUNK)
public class UpdateMobileAppCampaignAndCheckDbCampaignsMobileContent {
    private static final String CLIENT = CampaignsLogins.UPDATE_CLIENT_NEW_RMP;

    private static final String DEVICE_TYPE_PHONE = "phone";
    private static final String NETWORK_TARGETING_CELL = "cell";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;
    private DirectJooqDbSteps jooqDbSteps;
    private CampaignsMobileContentRecord campaignsMobileContent;

    @Before
    public void before() {
        Long clientId = Long.valueOf(User.get(CLIENT).getClientID());
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);

        Long mobileAppId = getOrCreateAnyClientApp(clientId);

        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();

        campaignsMobileContent = new CampaignsMobileContentRecord()
                .setCid(campaignId)
                .setMobileAppId(mobileAppId)
                .setDeviceTypeTargeting(DEVICE_TYPE_PHONE)
                .setIsInstalledApp(1)
                .setNetworkTargeting(NETWORK_TARGETING_CELL);
        jooqDbSteps.campaignsSteps().updateCampaignsMobileContent(campaignsMobileContent);

        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap().withCampaigns(
                new CampaignUpdateItemMap().withId(campaignId)
        ));
    }

    @Test
    public void checkRecordMobileContentAfterUpdate() {
        CampaignsMobileContentRecord actualCampaignsMobileContent = jooqDbSteps.campaignsSteps()
                .getCampaignsMobileContent(campaignId);
        assertThat("Значения в campaigns_mobile_content не должны измениться",
                actualCampaignsMobileContent, equalTo(campaignsMobileContent)
        );
    }

    private Long getOrCreateAnyClientApp(Long clientId) {
        return jooqDbSteps.mobileAppsSteps()
                .getMobileAppsByClient(clientId)
                .stream()
                .map(MobileAppsRecord::getMobileAppId)
                .findFirst()
                .orElse(createDefaultMobileApp(clientId));
    }

    private Long createDefaultMobileApp(Long clientId) {
        Long mobileContentId = jooqDbSteps.mobileContentSteps()
                .saveMobileContent(getDefaultMobileContent(clientId.toString()));
        return jooqDbSteps.mobileAppsSteps()
                .createMobileApp(getDefaultMobileAppsRecord(clientId, mobileContentId));
    }
}
