package ru.yandex.autotests.direct.api.campaigns.update.mobilecampaign;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.CampaignFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 01.10.15.
 * https://st.yandex-team.ru/TESTIRT-7291
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43063")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка статуса модерации после обновления кампании РМП")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateMobileAppCampaignAndCheckStatusModerateTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;
    private Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String status;

    @Parameterized.Parameters(name = "campaignType = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Status.YES},
                {Status.NO},
                {Status.SENT},
                {Status.READY},
                {Status.NEW},
        };
        return Arrays.asList(data);
    }

    @Before
    public void createCampaign() {
        id = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        api.userSteps.campaignFakeSteps().setStatusModerate(id, status);
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        assumeThat(String.format("StatusModerate у кампании = ", status),
                campaignFakeInfo.getStatusModerate(), equalTo(status));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("932")
    public void updateCampaignAndCheckStatus() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(id)
                                        .withName(RandomStringUtils.randomAlphabetic(10))
                                        .withNegativeKeywords("newNegativeKeywords")
                                        .withMobileAppCampaign(new MobileAppCampaignUpdateItemMap()
                                                .withBiddingStrategy(
                                                        new MobileAppCampaignStrategyMap().defaultMobileAppCampaignStrategy()
                                                                .withSearch(new MobileAppCampaignSearchStrategyMap()
                                                                        .defaultWbMaximumClicks(Currency.RUB))
                                                                .withNetwork(new MobileAppCampaignNetworkStrategyMap()
                                                                        .defaultServingOff())))
                        ),
                ExpectedResult.success());
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        assertThat(String.format("StatusModerate у кампании = ", status),
                campaignFakeInfo.getStatusModerate(), equalTo(status));
    }
}
