package ru.yandex.autotests.direct.api.campaigns.update.mobilecampaign;

import java.util.Collections;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.db.steps.JooqCampaignsOpts;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.containsString;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Description("Проверка обновления РМП кампании с флагом is_new_ios_version_enabled")
@Tag(TagDictionary.TRUNK)
public class UpdateMobileAppCampaignWithNewIosVersionEnabledFlagTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private DirectJooqDbSteps dbSteps;

    private Long cid;

    @Before
    public void setUp() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        dbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);

        cid = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();

        dbSteps.campaignsSteps().setOpts(cid, Collections.singletonList(JooqCampaignsOpts.IS_NEW_IOS_VERSION_ENABLED));
    }

    @Test
    public void shouldUpdateCampaignWithFlag() {
        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps()
                .getCampaigns(new GetRequestMap()
                        .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                                .withIds(cid)
                        ).withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.TYPE)
                );

        assumeThat("получили кампанию", campaigns, hasSize(1));

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                .withCampaigns(new CampaignUpdateItemMap()
                        .withId(cid)
                        .withMobileAppCampaign(new MobileAppCampaignUpdateItemMap()
                                .withSettings(new MobileAppCampaignSettingMap()
                                        .withOption(MobileAppCampaignSettingsEnum.ADD_TO_FAVORITES)
                                        .withValue(YesNoEnum.YES)
                                )
                        )
                ),
                ExpectedResult.success()
        );

        assumeThat("флаг is_new_ios_version_enabled сохранился",
                dbSteps.campaignsSteps().getCampaignById(cid).getOpts(),
                containsString(JooqCampaignsOpts.IS_NEW_IOS_VERSION_ENABLED.dbValue())
        );
    }
}
