package ru.yandex.autotests.direct.api.campaigns.update.mobilecampaign;


import java.util.Collections;
import java.util.List;
import java.util.Set;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.db.steps.JooqCampaignsOpts.IS_SKADNETWORK_ENABLED;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка обновления РМП кампании с флагом is_skadnetwork_enabled")
@Tag(TagDictionary.TRUNK)
public class UpdateMobileAppCampaignWithSkAdNetworkEnabledFlagTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long cid;
    private DirectJooqDbSteps dbSteps;

    @Before
    public void setUp() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        dbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        cid = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
    }

    @Test
    public void getCampaignWithFlag() {
        dbSteps.campaignsSteps().setOpts(cid, Collections.singletonList(IS_SKADNETWORK_ENABLED));
        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps()
                .getCampaigns(new GetRequestMap()
                        .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                                .withIds(cid)
                        ).withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.TYPE)
                );
        assumeThat("получили кампанию", campaigns, hasSize(1));
    }

    @Test
    public void shouldUpdateCampaignWithoutFlag() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(cid)
                                .withMobileAppCampaign(new MobileAppCampaignUpdateItemMap()
                                        .withSettings(new MobileAppCampaignSettingMap()
                                                .withOption(MobileAppCampaignSettingsEnum.ADD_TO_FAVORITES)
                                                .withValue(YesNoEnum.YES)
                                        )
                                )
                        ),
                ExpectedResult.success()
        );
        Set<String> opts = dbSteps.campaignsSteps().getOptsStr(cid);
        assumeThat("опция is_skadnetwork_enabled не была включена",
                opts, not(hasItem(IS_SKADNETWORK_ENABLED.dbValue())));
    }

    @Test
    public void shouldUpdateCampaignWithFlag() {
        dbSteps.campaignsSteps().setOpts(cid, Collections.singletonList(IS_SKADNETWORK_ENABLED));
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(cid)
                                .withMobileAppCampaign(new MobileAppCampaignUpdateItemMap()
                                        .withSettings(new MobileAppCampaignSettingMap()
                                                .withOption(MobileAppCampaignSettingsEnum.ADD_TO_FAVORITES)
                                                .withValue(YesNoEnum.YES)
                                        )
                                )
                        ),
                ExpectedResult.success()
        );
        Set<String> opts = dbSteps.campaignsSteps().getOptsStr(cid);
        assumeThat("опция is_skadnetwork_enabled осталась включенной",
                opts, hasItem(IS_SKADNETWORK_ENABLED.dbValue()));
    }
}
