package ru.yandex.autotests.direct.api.campaigns.update.mobilecampaign.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.util.streamex.StreamEx;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSettingGet;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.direct.api.campaigns.CampaignsDeprecatedSettings.MOBILE_APP_CAMPAIGN_DEPRECATED_SETTINGS;
import static ru.yandex.autotests.direct.api.campaigns.CampaignsDeprecatedSettings.MOBILE_APP_CAMPAIGN_DEPRECATED_SETTINGS_GET;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 04.02.16.
 * https://st.yandex-team.ru/TESTIRT-8435
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-50402")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка поля Settings. Независимость изменений с YES на NO")
@RunWith(Parameterized.class)
public class UpdateAndGetSettingsAllYesTest {
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static final String client = CampaignsLogins.GET_SERV_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public MobileAppCampaignSettingsEnum option;

    private Long campaignID;
    private Map<MobileAppCampaignSettingsGetEnum, YesNoEnum> expectedSettings;

    @Parameterized.Parameters(name = "option = {0}")
    public static Collection<Object[]> testData() {
        List<Object[]> data = new ArrayList<>();
        for (MobileAppCampaignSettingsEnum settingsEnum : MobileAppCampaignSettingsEnum.values()) {
            if (MOBILE_APP_CAMPAIGN_DEPRECATED_SETTINGS.contains(settingsEnum)) {
                continue;
            }
            data.add(new Object[]{settingsEnum});
        }
        return data;
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareCampaign() {
        expectedSettings = new HashMap<>();
        for (MobileAppCampaignSettingsGetEnum settingsEnum : MobileAppCampaignSettingsGetEnum.values()) {
            if (MOBILE_APP_CAMPAIGN_DEPRECATED_SETTINGS_GET.contains(settingsEnum)) {
                continue;
            }

            YesNoEnum value = YesNoEnum.YES;
            //REQUIRE_SERVICING и SHARED_ACCOUNT_ENABLED не переопределить
            if ((settingsEnum.value().equals(option.value())
                    && !option.equals(MobileAppCampaignSettingsEnum.REQUIRE_SERVICING))
                    || settingsEnum.equals(MobileAppCampaignSettingsGetEnum.SHARED_ACCOUNT_ENABLED))
            {
                value = YesNoEnum.NO;
            }

            expectedSettings.put(settingsEnum, value);
        }

        ArrayList<MobileAppCampaignSettingMap> settings = new ArrayList<>();
        for (MobileAppCampaignSettingsEnum settingsEnum : MobileAppCampaignSettingsEnum.values()) {
            if (MOBILE_APP_CAMPAIGN_DEPRECATED_SETTINGS.contains(settingsEnum)) {
                continue;
            }

            settings.add(new MobileAppCampaignSettingMap().withOption(settingsEnum).withValue(YesNoEnum.YES));
        }

        campaignID = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withMobileAppCampaign(new MobileAppCampaignAddItemMap()
                                .defaultMobileAppCampaign()
                                .withSettings(settings.toArray(new MobileAppCampaignSettingMap[settings.size()]))
                        ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1023")
    public void checkUpdateSettingsTest() {
        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                .withId(campaignID)
                .withMobileAppCampaign(new MobileAppCampaignUpdateItemMap()
                        .withSettings(new MobileAppCampaignSettingMap()
                                .withOption(option)
                                .withValue(YesNoEnum.NO)))
        ));

        GetResponse getResponse = api.as(client).userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                                .withIds(campaignID))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withMobileAppCampaignFieldNames(MobileAppCampaignFieldEnum.SETTINGS));
        assumeThat("получили созданную кампанию", getResponse.getCampaigns(), hasSize(1));

        List<MobileAppCampaignSettingGet> settings =
                getResponse.getCampaigns().get(0).getMobileAppCampaign().getSettings();
        assumeThat("получили настройки кампании", settings, notNullValue());

        Map<MobileAppCampaignSettingsGetEnum, YesNoEnum> settingsActual = StreamEx.of(settings)
                .filter(s -> !MOBILE_APP_CAMPAIGN_DEPRECATED_SETTINGS_GET.contains(s.getOption()))
                .toMap(MobileAppCampaignSettingGet::getOption, MobileAppCampaignSettingGet::getValue);

        assertThat("вернулся ожидаемый набор настроек", settingsActual, beanDifferV5(expectedSettings));
    }
}
