package ru.yandex.autotests.direct.api.campaigns.update.mobilecampaign.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerPhraseFakeInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.CampaignFakeInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyNetworkDefaultAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 06.10.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Поверка StatusBsSynced мобильной кампании после обновления стратегии")
@RunWith(Parameterized.class)
public class CheckStatusBsSyncedAfterUpdateStrategyTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long id;
    private Long adGroupId;
    private Long adId;
    private Long keywordId;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public MobileAppCampaignSearchStrategyAddMap searchStrategyForCreate;

    @Parameterized.Parameter(2)
    public MobileAppCampaignNetworkStrategyAddMap networkStrategyForCreate;

    @Parameterized.Parameter(3)
    public MobileAppCampaignSearchStrategyMap searchStrategyForUpdate;

    @Parameterized.Parameter(4)
    public MobileAppCampaignNetworkStrategyMap networkStrategyForUpdate;

    @Parameterized.Parameter(5)
    public JavaOrPerlExpectedResult expectedResultForUpdate;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Ручная + Ручная -> Нераздельное упраление, Авто",
                        new MobileAppCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new MobileAppCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                        new MobileAppCampaignSearchStrategyMap().defaultWbMaximumClicks(Currency.RUB),
                        new MobileAppCampaignNetworkStrategyMap().defaultNetworkDefault(),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.warnings(
                                new Notification(10165, Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED, capitalize(
                                        StrategyNetworkDefaultAddMap.LIMIT_PERCENT)),
                                new Notification(10163, Api5ErrorDetails.SETTING_WILL_NOT_BE_CHANGED,
                                        TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC)))
                },
                {"Ручная + Ручная -> Авто + ServingOff",
                        new MobileAppCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new MobileAppCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                        new MobileAppCampaignSearchStrategyMap().defaultWbMaximumClicks(Currency.RUB),
                        new MobileAppCampaignNetworkStrategyMap().defaultServingOff(),
                        JavaOrPerlExpectedResult.both(ExpectedResult.success())
                },
                {"Ручная + Ручная -> ServingOff + Авто",
                        new MobileAppCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new MobileAppCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                        new MobileAppCampaignSearchStrategyMap().defaultServingOff(),
                        new MobileAppCampaignNetworkStrategyMap().defaultWbMaximumClicks(Currency.RUB),
                        JavaOrPerlExpectedResult.both(ExpectedResult.success())
                },
                {"ServingOff + Ручная -> Нераздельное упраление, Авто",
                        new MobileAppCampaignSearchStrategyAddMap().defaultServingOff(),
                        new MobileAppCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                        new MobileAppCampaignSearchStrategyMap().defaultWbMaximumClicks(Currency.RUB),
                        new MobileAppCampaignNetworkStrategyMap().defaultNetworkDefault(),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.warnings(
                                new Notification(10165, Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED, capitalize(
                                        StrategyNetworkDefaultAddMap.LIMIT_PERCENT)),
                                new Notification(10163, Api5ErrorDetails.SETTING_WILL_NOT_BE_CHANGED,
                                        TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC)))
                },
                {"ServingOff + Ручная -> Авто + ServingOff",
                        new MobileAppCampaignSearchStrategyAddMap().defaultServingOff(),
                        new MobileAppCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                        new MobileAppCampaignSearchStrategyMap().defaultWbMaximumClicks(Currency.RUB),
                        new MobileAppCampaignNetworkStrategyMap().defaultServingOff(),
                        JavaOrPerlExpectedResult.both(ExpectedResult.success())
                },
                {"ServingOff + Ручная -> ServingOff + Авто",
                        new MobileAppCampaignSearchStrategyAddMap().defaultServingOff(),
                        new MobileAppCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                        new MobileAppCampaignSearchStrategyMap().defaultServingOff(),
                        new MobileAppCampaignNetworkStrategyMap().defaultWbMaximumClicks(Currency.RUB),
                        JavaOrPerlExpectedResult.both(ExpectedResult.success())
                },
                {"Ручная + ServingOff -> Нераздельное упраление, Авто",
                        new MobileAppCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new MobileAppCampaignNetworkStrategyAddMap().defaultServingOff(),
                        new MobileAppCampaignSearchStrategyMap().defaultWbMaximumClicks(Currency.RUB),
                        new MobileAppCampaignNetworkStrategyMap().defaultNetworkDefault(),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.success())
                                .perl(ExpectedResult.warnings(
                                new Notification(10165, Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED, capitalize(
                                        StrategyNetworkDefaultAddMap.LIMIT_PERCENT)),
                                new Notification(10163, Api5ErrorDetails.SETTING_WILL_NOT_BE_CHANGED,
                                        TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC)))
                },
                {"Ручная + ServingOff -> Авто + ServingOff",
                        new MobileAppCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new MobileAppCampaignNetworkStrategyAddMap().defaultServingOff(),
                        new MobileAppCampaignSearchStrategyMap().defaultWbMaximumClicks(Currency.RUB),
                        new MobileAppCampaignNetworkStrategyMap().defaultServingOff(),
                        JavaOrPerlExpectedResult.both(ExpectedResult.success())
                },
                {"Ручная + ServingOff -> ServingOff + Авто",
                        new MobileAppCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new MobileAppCampaignNetworkStrategyAddMap().defaultServingOff(),
                        new MobileAppCampaignSearchStrategyMap().defaultServingOff(),
                        new MobileAppCampaignNetworkStrategyMap().defaultWbMaximumClicks(Currency.RUB),
                        JavaOrPerlExpectedResult.both(ExpectedResult.success())
                },
        });
    }

    @BeforeClass
    public static void prepareClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Before
    public void createCampaign() {
        id = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withMobileAppCampaign(new MobileAppCampaignAddItemMap()
                        .withBiddingStrategy(new MobileAppCampaignStrategyAddMap()
                                .withSearch(searchStrategyForCreate)
                                .withNetwork(networkStrategyForCreate))));
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(id);
        adId = api.userSteps.adsSteps().addDefaultMobileAppAd(adGroupId);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);

        api.userSteps.campaignFakeSteps().setBSSynced(id, true);
        api.userSteps.campaignFakeSteps().setStatusModerate(id, Status.YES);
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        assumeThat("у кампании StatusBsSynced = Yes", campaignFakeInfo.getStatusBsSynced(), equalTo(Value.YES));
        assumeThat("у кампании StatusModerate = Yes", campaignFakeInfo.getStatusModerate(), equalTo(Status.YES));

        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(adGroupId, Value.YES);
        GroupFakeInfo groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupId);
        assumeThat("у группы StatusBsSynced = Yes", groupFakeInfo.getStatusBsSynced(), equalTo(Value.YES));

        api.userSteps.bannersFakeSteps().setStatusBsSynced(adId, Value.YES);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assumeThat("у объявления StatusBsSynced = Yes", bannerFakeInfo.getStatusBsSynced(), equalTo(Value.YES));

        api.userSteps.phrasesFakeSteps().setStatusBsSynced(keywordId, Value.YES);
        BannerPhraseFakeInfo bannerPhraseFakeInfo =
                api.userSteps.phrasesFakeSteps().getBannerPhraseParams(keywordId);
        assumeThat("у фразы StatusBsSynced = Yes", bannerPhraseFakeInfo.getStatusBsSynced(), equalTo(Value.YES));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1033")
    public void updateStrategy() {
        //DIRECT-46406
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withMobileAppCampaign(new MobileAppCampaignUpdateItemMap()
                                        .withBiddingStrategy(new MobileAppCampaignStrategyMap()
                                                .withSearch(searchStrategyForUpdate)
                                                .withNetwork(networkStrategyForUpdate)))),
                expectedResultForUpdate);
        checkStatuses(Value.NO, Value.YES, Value.YES, Value.YES);
    }

    public void checkStatuses(String campaignStatus, String adGroupStatus, String adStatus, String keywordStatus) {
        List<String> statuses = new ArrayList<String>();
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        statuses.add(campaignFakeInfo.getStatusBsSynced());
        GroupFakeInfo groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupId);
        statuses.add(groupFakeInfo.getStatusBsSynced());
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        statuses.add(bannerFakeInfo.getStatusBsSynced());
        BannerPhraseFakeInfo bannerPhraseFakeInfo =
                api.userSteps.phrasesFakeSteps().getBannerPhraseParams(keywordId);
        statuses.add(bannerPhraseFakeInfo.getStatusBsSynced());
        assertThat("объекты имеют правильные статусы (campaign, adGroup, ad, keyword)",
                statuses, equalTo(Arrays.asList(campaignStatus, adGroupStatus, adStatus, keywordStatus)));
    }
}
