package ru.yandex.autotests.direct.api.campaigns.update.mobilecampaign.strategy;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignStrategy;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyNetworkDefaultMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 06.10.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Позитивные сценарии создания мобильной кампании с автостратегиями для Search и комбинациями стратегий для Network")
@Tag(TagDictionary.TRUNK)
public class StrategyCombinationsAutoSearchTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String searchName;

    @Parameterized.Parameter(value = 1)
    public String contextName;

    @Parameterized.Parameter(value = 2)
    public MobileAppCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameter(value = 3)
    public MobileAppCampaignNetworkStrategyMap networkStrategy;

    @Parameterized.Parameter(value = 4)
    public MobileAppCampaignNetworkStrategyMap expectedNetworkStrategy;

    @Parameterized.Parameters(name = "search = {0}, context = {1}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                //ServingOff для Network
                {"AverageCpc", "ServingOff",
                        new MobileAppCampaignSearchStrategyMap().defaultAverageCpc(currency),
                        new MobileAppCampaignNetworkStrategyMap().defaultServingOff(),
                        new MobileAppCampaignNetworkStrategyMap().defaultServingOff(),
                },
                //DIRECT-47130
                {"AverageCpi", "ServingOff",
                        new MobileAppCampaignSearchStrategyMap().defaultAverageCpi(currency),
                        new MobileAppCampaignNetworkStrategyMap().defaultServingOff(),
                        new MobileAppCampaignNetworkStrategyMap().defaultServingOff(),
                },
                {"MaximumAppInstalls", "ServingOff",
                        new MobileAppCampaignSearchStrategyMap().defaultWbMaximumAppInstalls(currency),
                        new MobileAppCampaignNetworkStrategyMap().defaultServingOff(),
                        new MobileAppCampaignNetworkStrategyMap().defaultServingOff(),
                },
                {"MaximumClicks", "ServingOff",
                        new MobileAppCampaignSearchStrategyMap().defaultWbMaximumClicks(currency),
                        new MobileAppCampaignNetworkStrategyMap().defaultServingOff(),
                        new MobileAppCampaignNetworkStrategyMap().defaultServingOff(),
                },

                //NetworkDefault для Network
                {"AverageCpc", "NetworkDefault",
                        new MobileAppCampaignSearchStrategyMap().defaultAverageCpc(currency),
                        new MobileAppCampaignNetworkStrategyMap().defaultNetworkDefault(),
                        new MobileAppCampaignNetworkStrategyMap().withBiddingStrategyType(
                                MobileAppCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT
                        ),
                },
                //DIRECT-47130
                {"AverageCpi", "NetworkDefault",
                        new MobileAppCampaignSearchStrategyMap().defaultAverageCpi(currency),
                        new MobileAppCampaignNetworkStrategyMap().withBiddingStrategyType(
                                MobileAppCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT
                        ).withNetworkDefault(new StrategyNetworkDefaultMap()),
                        new MobileAppCampaignNetworkStrategyMap().withBiddingStrategyType(
                                MobileAppCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT
                        ),
                },
                {"MaximumAppInstalls", "NetworkDefault",
                        new MobileAppCampaignSearchStrategyMap().defaultWbMaximumAppInstalls(currency),
                        new MobileAppCampaignNetworkStrategyMap().withBiddingStrategyType(
                                MobileAppCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT
                        ).withNetworkDefault(new StrategyNetworkDefaultMap()),
                        new MobileAppCampaignNetworkStrategyMap().withBiddingStrategyType(
                                MobileAppCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT
                        )
                },
                {"MaximumClicks", "NetworkDefault",
                        new MobileAppCampaignSearchStrategyMap().defaultWbMaximumClicks(currency),
                        new MobileAppCampaignNetworkStrategyMap().defaultNetworkDefault(),
                        new MobileAppCampaignNetworkStrategyMap().withBiddingStrategyType(
                                MobileAppCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT
                        ),
                },
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1035")
    public void strategyNetworkTest() {
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();

        api.userSteps.campaignSteps().campaignsUpdateWithCheck(new CampaignUpdateItemMap()
                .withId(campaignId)
                .withMobileAppCampaign(new MobileAppCampaignUpdateItemMap()
                        .withBiddingStrategy(new MobileAppCampaignStrategyMap()
                                .withSearch(searchStrategy)
                                .withNetwork(networkStrategy))));

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withMobileAppCampaignFieldNames(MobileAppCampaignFieldEnum.BIDDING_STRATEGY));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        MobileAppCampaignStrategy actualStrategy = campaigns.get(0).getMobileAppCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        MobileAppCampaignStrategyMap expectedStrategy = new MobileAppCampaignStrategyMap()
                .withSearch(searchStrategy)
                .withNetwork(expectedNetworkStrategy);

        assertThat("получили корректные стратегии", actualStrategy,
                beanDifferV5((MobileAppCampaignStrategy) expectedStrategy.getBean()));
    }
}
