package ru.yandex.autotests.direct.api.campaigns.update.mobilecampaign.strategy;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignStrategy;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyNetworkDefaultAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 06.10.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Обновление мобильной кампании с ручными стратегиями для Search и допустимыми комбинациями стратегий для" +
        " Network")
@Tag(TagDictionary.TRUNK)
public class StrategyCombinationsManualSearchTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public MobileAppCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameter(value = 2)
    public MobileAppCampaignNetworkStrategyMap networkStrategy;

    @Parameterized.Parameter(value = 3)
    public MobileAppCampaignSearchStrategyAddMap searchStrategyAdd;

    @Parameterized.Parameter(value = 4)
    public MobileAppCampaignNetworkStrategyAddMap networkStrategyAdd;

    @Parameterized.Parameters(name = "Strategy = {0}")
    public static Collection roles() {
        Object[][] data = new Object[][]{
                {"HighestPosition + MaximumCoverage",
                        new MobileAppCampaignSearchStrategyMap()
                                .withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.HIGHEST_POSITION),
                        new MobileAppCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE),
                        new MobileAppCampaignSearchStrategyAddMap()
                                .withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.HIGHEST_POSITION),
                        new MobileAppCampaignNetworkStrategyAddMap()
                                .withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE)},
                {"HighestPosition + ServingOff",
                        new MobileAppCampaignSearchStrategyMap()
                                .withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.HIGHEST_POSITION),
                        new MobileAppCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.SERVING_OFF),
                        new MobileAppCampaignSearchStrategyAddMap()
                                .withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.HIGHEST_POSITION),
                        new MobileAppCampaignNetworkStrategyAddMap()
                                .withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.SERVING_OFF)}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1036")
    public void updateCampaignStrategyTest() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .defaultCampaignUpdateItem()
                        .withId(campaignId)
                        .withMobileAppCampaign(new MobileAppCampaignUpdateItemMap()
                                .withBiddingStrategy(new MobileAppCampaignStrategyMap()
                                        .withSearch(searchStrategy)
                                        .withNetwork(networkStrategy)))),
                ExpectedResult.success(campaignId));

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withMobileAppCampaignFieldNames(MobileAppCampaignFieldEnum.BIDDING_STRATEGY));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        MobileAppCampaignStrategy actualStrategy = campaigns.get(0).getMobileAppCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        MobileAppCampaignStrategyMap expectedStrategy = new MobileAppCampaignStrategyMap()
                .withSearch(searchStrategy)
                .withNetwork(networkStrategy);

        assertThat("получили корректные стратегии", actualStrategy,
                beanDifferV5((MobileAppCampaignStrategy) expectedStrategy.getBean()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1037")
    public void updateToAutoStrategyTest() {
        List<Long> ids = api.userSteps.campaignSteps().campaignsAddWithCheck(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withMobileAppCampaign(new MobileAppCampaignAddItemMap()
                        .withBiddingStrategy(new MobileAppCampaignStrategyAddMap()
                                .withSearch(searchStrategyAdd)
                                .withNetwork(networkStrategyAdd))));
        assumeThat("создана кампания", ids, hasSize(1));

        log.info("Изменим стратегию кампании на автобюджетную");
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .defaultCampaignUpdateItem()
                        .withId(ids.get(0))
                        .withMobileAppCampaign(new MobileAppCampaignUpdateItemMap()
                                .withBiddingStrategy(new MobileAppCampaignStrategyMap()
                                        .withSearch(
                                                new MobileAppCampaignSearchStrategyMap().defaultAverageCpc(currency))
                                        .withNetwork(
                                                new MobileAppCampaignNetworkStrategyMap().defaultNetworkDefault())))),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.success())
                        .perl(ExpectedResult.warnings(
                                new Notification(10165, Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED, capitalize(
                                        StrategyNetworkDefaultAddMap.LIMIT_PERCENT)),
                                new Notification(10163, Api5ErrorDetails.SETTING_WILL_NOT_BE_CHANGED,
                                        TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC)))
        );

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(ids.get(0)))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withMobileAppCampaignFieldNames(MobileAppCampaignFieldEnum.BIDDING_STRATEGY));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        MobileAppCampaignStrategy actualStrategy = campaigns.get(0).getMobileAppCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        MobileAppCampaignStrategyMap expectedStrategy = new MobileAppCampaignStrategyMap()
                .withSearch(new MobileAppCampaignSearchStrategyMap().defaultAverageCpc(currency))
                .withNetwork(new MobileAppCampaignNetworkStrategyMap()
                        .withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT));

        assertThat("стратегия изменена на автобюджетную", actualStrategy,
                beanDifferV5((MobileAppCampaignStrategy) expectedStrategy.getBean()));
    }
}
