package ru.yandex.autotests.direct.api.campaigns.update.mobilecampaign.strategy;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 06.10.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Негативные сценарии обновления мобильной кампаний со стратегиями, которые не сочетаются друг с другом")
@Tag(TagDictionary.TRUNK)
public class StrategyCombinationsNegativeTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public MobileAppCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameter(value = 2)
    public MobileAppCampaignNetworkStrategyMap networkStrategy;

    @Parameterized.Parameters(name = "strategy = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                //отключено на поиске и на сети
                {"ServingOff + ServingOff",
                        new MobileAppCampaignSearchStrategyMap().defaultServingOff(),
                        new MobileAppCampaignNetworkStrategyMap().defaultServingOff()},
                //отключено на поиске и NetworkDefault на сети
                {"ServingOff + NetworkDefault",
                        new MobileAppCampaignSearchStrategyMap().defaultServingOff(),
                        new MobileAppCampaignNetworkStrategyMap().defaultNetworkDefault()},
                //ручная стратегия на поиске и автоматическая на сети
                {"HighestPosition + AverageCpc",
                        new MobileAppCampaignSearchStrategyMap().defaultHighestPosition(),
                        new MobileAppCampaignNetworkStrategyMap().defaultAverageCpc(currency)},
                //DIRECT-47130
                {"HighestPosition + MaximumAppInstalls",
                        new MobileAppCampaignSearchStrategyMap().defaultHighestPosition(),
                        new MobileAppCampaignNetworkStrategyMap().defaultWbMaximumAppInstalls(currency)},
                //автоматическая стратегия на поиске и автоматическая на сети
                {"MaximumClicks + AverageCpi",
                        new MobileAppCampaignSearchStrategyMap().defaultWbMaximumClicks(currency),
                        new MobileAppCampaignNetworkStrategyMap().defaultAverageCpi(currency)},
                //автоматическая стратегия на поиске и MaximumCoverage на сети
                {"MaximumClicks + MaximumCoverage",
                        new MobileAppCampaignSearchStrategyMap().defaultWbMaximumClicks(currency),
                        new MobileAppCampaignNetworkStrategyMap().defaultMaximumCoverage()}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1038")
    public void strategyCombinationNegativeTest() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withMobileAppCampaign(new MobileAppCampaignUpdateItemMap()
                                .withBiddingStrategy(new MobileAppCampaignStrategyMap()
                                        .withSearch(searchStrategy)
                                        .withNetwork(networkStrategy)))),
                ExpectedResult.errors(new Notification(4000, Api5ErrorDetails.STRATEGIES_NOT_COMPATIBLE)));
    }
}
