package ru.yandex.autotests.direct.api.campaigns.update.mobilecampaign.strategy;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.MobileAppCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpcMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumClicksMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 06.10.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Обновление мобильной кампании при несоответствии имени стратегии и набора переданных параметров " +
        "стратегии")
@Tag(TagDictionary.TRUNK)
public class StrategyNameMismatchParamsTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static MoneyCurrency moneyCurrency = MoneyCurrency.get(currency);
    private Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public MobileAppCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameter(value = 2)
    public MobileAppCampaignNetworkStrategyMap networkStrategy;

    @Parameterized.Parameter(value = 3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "strategy = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                //DIRECT-46091
                {"Search: несоответствие имени и параметров",
                        new MobileAppCampaignSearchStrategyMap()
                                .withBiddingStrategyType(
                                        MobileAppCampaignSearchStrategyTypeEnum.WB_MAXIMUM_APP_INSTALLS)
                                .withAverageCpc(
                                new StrategyAverageCpcMap()
                                        .withAverageCpc(moneyCurrency.getMinAveragePrice().bidLong().longValue())
                                        .withWeeklySpendLimit(
                                                moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        new MobileAppCampaignNetworkStrategyMap().defaultServingOff(),
                        ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.SEARCH_STRATEGY_NAME_MISMATCH_WITH_PARAMETERS))},
                {"Search: стратегия не требующая параметров",
                        new MobileAppCampaignSearchStrategyMap()
                                .withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.HIGHEST_POSITION)
                                .withWbMaximumClicks(new StrategyMaximumClicksMap()
                                .defaultStrategyMaximumClicks(Currency.RUB)),
                        new MobileAppCampaignNetworkStrategyMap().defaultServingOff(),
                        ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.SEARCH_STRATEGY_NAME_MISMATCH_WITH_PARAMETERS))},
                //DIRECT-46816
                {"Search: стратегия без необходимых парметров",
                        new MobileAppCampaignSearchStrategyMap()
                                .withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.AVERAGE_CPC),
                        new MobileAppCampaignNetworkStrategyMap().defaultNetworkDefault(),
                        ExpectedResult.errors(
                                new Notification(4000, Api5ErrorDetails.STRATEGY_ON_SEARCH_MUST_CONTAINS_SETTINGS,
                                        MobileAppCampaignSearchStrategyTypeEnum.AVERAGE_CPC))},
                {"Search: лишние параметры стратегий",
                        new MobileAppCampaignSearchStrategyMap()
                                .withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                                .withAverageCpc(new StrategyAverageCpcMap()
                                        .withAverageCpc(moneyCurrency.getMinAveragePrice().bidLong().longValue())
                                        .withWeeklySpendLimit(
                                                moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue()))
                                .withWbMaximumClicks(new StrategyMaximumClicksMap()
                                .defaultStrategyMaximumClicks(Currency.RUB)),
                        new MobileAppCampaignNetworkStrategyMap().defaultServingOff(),
                        ExpectedResult.errors(
                                new Notification(4000, Api5ErrorDetails.MULTIPLE_SEARCH_STRATEGY_PARAMS))},
                {"Network: несоответствие имени и параметров",
                        new MobileAppCampaignSearchStrategyMap().defaultServingOff(),
                        new MobileAppCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                                .withAverageCpc(new StrategyAverageCpcMap()
                                .withAverageCpc(moneyCurrency.getMinAveragePrice().bidLong().longValue())
                                .withWeeklySpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.NETWORK_STRATEGY_NAME_MISMATCH_WITH_PARAMETERS))},
                {"Network: стратегия не требующая параметров",
                        new MobileAppCampaignSearchStrategyMap().defaultServingOff(),
                        new MobileAppCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE)
                                .withAverageCpc(new StrategyAverageCpcMap()
                                .withAverageCpc(moneyCurrency.getMinAveragePrice().bidLong().longValue())
                                .withWeeklySpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.NETWORK_STRATEGY_NAME_MISMATCH_WITH_PARAMETERS))},
                {"Network: стратегия без необходимых парметров",
                        new MobileAppCampaignSearchStrategyMap().defaultServingOff(),
                        new MobileAppCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.AVERAGE_CPI),
                        ExpectedResult.errors(
                                new Notification(4000, Api5ErrorDetails.STRATEGY_ON_NETWORK_MUST_CONTAINS_SETTINGS,
                                        MobileAppCampaignNetworkStrategyTypeEnum.AVERAGE_CPI))},
                {"Network: лишние параметры стратегий",
                        new MobileAppCampaignSearchStrategyMap().defaultServingOff(),
                        new MobileAppCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                                .withWbMaximumClicks(
                                        new StrategyMaximumClicksMap().defaultStrategyMaximumClicks(currency))
                                .withAverageCpc(new StrategyAverageCpcMap()
                                .withAverageCpc(moneyCurrency.getMinAveragePrice().bidLong().longValue())
                                .withWeeklySpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        ExpectedResult.errors(
                                new Notification(4000, Api5ErrorDetails.MULTIPLE_NETWORK_STRATEGY_PARAMS))},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1039")
    public void nameMismatchParamsTest() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withMobileAppCampaign(new MobileAppCampaignUpdateItemMap()
                                .withBiddingStrategy(new MobileAppCampaignStrategyMap()
                                        .withSearch(searchStrategy)
                                        .withNetwork(networkStrategy)))),
                expectedResult);
    }
}
