package ru.yandex.autotests.direct.api.campaigns.update.mobilecampaign.strategy;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpcMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpiMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumAppInstallsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumClicksMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 28.10.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Обновление мобильной кампании со сменой стратегии на поиске без указания всех обязательных полей новой стратегии")
@Issue("https://st.yandex-team.ru/DIRECT-46885")
@Tag(TagDictionary.TRUNK)
public class UpdateSearchToStrategyWithoutRequiredFieldsTest {

    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static MoneyCurrency moneyCurrency = MoneyCurrency.get(currency);
    private static Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public MobileAppCampaignSearchStrategyMap searchStrategyUpdate;

    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "strategy = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                //DIRECT-46091
                {"WbMaximumClicks without WeeklySpendLimit",
                        new MobileAppCampaignSearchStrategyMap()
                                .withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                                .withWbMaximumClicks(new StrategyMaximumClicksMap()
                                .withBidCeiling(null)),
                        ExpectedResult.errors(
                                new Notification(4000, Api5ErrorDetails.WEEKLY_BUDGET_MUST_NOT_SPECIFIED))},
                {"WbMaximumAppInstalls without WeeklySpendLimit",
                        new MobileAppCampaignSearchStrategyMap()
                                .withBiddingStrategyType(
                                        MobileAppCampaignSearchStrategyTypeEnum.WB_MAXIMUM_APP_INSTALLS)
                                .withWbMaximumAppInstalls(new StrategyMaximumAppInstallsMap()
                                .withBidCeiling(null)),
                        ExpectedResult.errors(
                                new Notification(4000, Api5ErrorDetails.WEEKLY_BUDGET_MUST_NOT_SPECIFIED))},
                {"AverageCpc without AverageCpc",
                        new MobileAppCampaignSearchStrategyMap()
                                .withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.AVERAGE_CPC)
                                .withAverageCpc(new StrategyAverageCpcMap()
                                .withWeeklySpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        ExpectedResult.errors(
                                new Notification(4000, Api5ErrorDetails.AVERAGE_CPC_VALUE_NOT_SPECIFIED))},
                {"AverageCpi without AverageCpi",
                        new MobileAppCampaignSearchStrategyMap()
                                .withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.AVERAGE_CPI)
                                .withAverageCpi(new StrategyAverageCpiMap()
                                .withWeeklySpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        ExpectedResult.errors(new Notification(4000, Api5ErrorDetails.AVERAGE_CPI_NOT_SPECIFIED))},
        };
        return Arrays.asList(data);
    }


    @BeforeClass
    public static void addCampaign() {
        campaignId = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withMobileAppCampaign(new MobileAppCampaignAddItemMap()
                        .withBiddingStrategy(new MobileAppCampaignStrategyAddMap()
                                .withSearch(new MobileAppCampaignSearchStrategyAddMap()
                                        .withBiddingStrategyType(
                                                MobileAppCampaignSearchStrategyTypeEnum.HIGHEST_POSITION))
                                .withNetwork(new MobileAppCampaignNetworkStrategyAddMap().defaultServingOff()))));
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1042")
    public void nameMismatchParamsTest() {
        //DIRECT-47698
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withMobileAppCampaign(new MobileAppCampaignUpdateItemMap()
                                .withBiddingStrategy(new MobileAppCampaignStrategyMap()
                                        .withSearch(searchStrategyUpdate)))),
                expectedResult);
    }
}
