package ru.yandex.autotests.direct.api.campaigns.update.mobilecampaign.strategy.averagecpi;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;

import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpiMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyNetworkDefaultAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.sun.xml.ws.util.StringUtils.capitalize;
import static org.hamcrest.Matchers.nullValue;

/**
 * Created by chicos on 05.10.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Проверка взаимных сочетаний параметров BidCeiling, AverageCpi, WeeklySpendLimit при обновлении " +
        "мобильной кампании со стратегией AverageCpi")
public class StrategyAverageCpiPriceCombinationsTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private Long campaignId;

    private static final MoneyCurrency moneyCurrency = MoneyCurrency.get(currency);

    private MobileAppCampaignStrategyMap strategyMap;
    private static final Function<Long, JavaOrPerlExpectedResult> expectedResultWithWarnings =
            (campaignId) -> JavaOrPerlExpectedResult.java(ExpectedResult.success())
                    .perl(ExpectedResult.warnings(campaignId,
                            new Notification(10165, Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED, capitalize(
                                    StrategyNetworkDefaultAddMap.LIMIT_PERCENT)),
                            new Notification(10163, Api5ErrorDetails.SETTING_WILL_NOT_BE_CHANGED,
                                    TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC))
                    );

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public Money bidCeiling;

    @Parameterized.Parameter(value = 1)
    public Money averageCpi;

    @Parameterized.Parameter(value = 2)
    public Money weeklyLimit;

    @Parameterized.Parameter(value = 3)
    public Function<Long, JavaOrPerlExpectedResult> expectedResult;

    @Parameterized.Parameters(name = "bidCeiling = {0}, averageCpi = {1}, limit = {2}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                //допустимые значения
                //minCpa <= cpa <= limit
                //minPrice <= bid <= limit
                //minWeeklyLimit <= limit <= maxWeeklyLimit
                //взаимозависимости между cpa и bid - нет

                //cpi < bid < limit
                {moneyCurrency.getMinAveragePrice().getNext(), moneyCurrency.getMinAveragePrice(),
                        moneyCurrency.getMinWeeklyBudgetAmount(),
                        expectedResultWithWarnings},
                //bid = cpi (= minCpa)
                {moneyCurrency.getMinAveragePrice(), moneyCurrency.getMinAveragePrice(), null,
                        expectedResultWithWarnings},
                //bid = cpi (= maxPrice)
                {moneyCurrency.getMaxPrice(), moneyCurrency.getMaxPrice(), null,
                        expectedResultWithWarnings},
                //cpi < limit
                {null, moneyCurrency.getMinAveragePrice(), moneyCurrency.getMinWeeklyBudgetAmount(),
                        expectedResultWithWarnings},

                //cpi = bid = limit
                {moneyCurrency.getMinWeeklyBudgetAmount(), moneyCurrency.getMinWeeklyBudgetAmount(),
                        moneyCurrency.getMinWeeklyBudgetAmount(),
                        expectedResultWithWarnings},
                //cpi = limit
                {null, moneyCurrency.getMinWeeklyBudgetAmount(), moneyCurrency.getMinWeeklyBudgetAmount(),
                        expectedResultWithWarnings},
                //bid = limit
                {moneyCurrency.getMinWeeklyBudgetAmount(), moneyCurrency.getMinWeeklyBudgetAmount().getPrevious(),
                        moneyCurrency.getMinWeeklyBudgetAmount(),
                        expectedResultWithWarnings},

                //bid < cpi
                {moneyCurrency.getMinAveragePrice(), moneyCurrency.getMinAveragePrice().getNext(), null,
                        expectedResultWithWarnings},
                //bid > limit
                {moneyCurrency.getMinWeeklyBudgetAmount().getNext(),
                        moneyCurrency.getMinWeeklyBudgetAmount().getPrevious(),
                        moneyCurrency.getMinWeeklyBudgetAmount(),
                        (Function) campaignId -> JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(4000,
                                        Api5ErrorDetailsJava.MUST_BE_LESS_THAN_OR_EQUAL_TO_WEEKLY_BUDGET,
                                        "BidCeiling")))
                                .perl(ExpectedResult.create(nullValue(),
                                Arrays.asList(
                                        new Notification(10165, Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED,
                                                StringUtils.capitalize(
                                                        StrategyNetworkDefaultAddMap.LIMIT_PERCENT)),
                                        new Notification(10163, Api5ErrorDetails.SETTING_WILL_NOT_BE_CHANGED,
                                                TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC)),
                                Arrays.asList(new Notification(4000,
                                        Api5ErrorDetails.WEEKLY_BUDGET_MUST_BE_GREATER_THAN_MAXIMUM_BID))))
                },
                //cpi > limit
                {null, moneyCurrency.getMinWeeklyBudgetAmount().getNext(), moneyCurrency.getMinWeeklyBudgetAmount(),
                        (Function) campaignId ->  JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(4000,
                                        Api5ErrorDetailsJava.MUST_BE_LESS_THAN_OR_EQUAL_TO_WEEKLY_BUDGET,
                                        "AverageCpi")))
                                .perl(ExpectedResult.create(nullValue(),
                                Arrays.asList(new Notification(10163, Api5ErrorDetails.SETTING_WILL_NOT_BE_CHANGED,
                                                TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC),
                                        new Notification(10165, Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED, capitalize(
                                                StrategyNetworkDefaultAddMap.LIMIT_PERCENT))),
                                Arrays.asList(new Notification(4000,
                                        Api5ErrorDetails.WEEKLY_LIMIT_SHOULD_BE_GREATER_THAN_AVERAGE_CPI))))
                }
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();

        StrategyAverageCpiMap params = new StrategyAverageCpiMap();
        if (weeklyLimit != null) {
            params.withWeeklySpendLimit(weeklyLimit.bidLong().longValue());
        }
        if (bidCeiling != null) {
            params.withBidCeiling(bidCeiling.bidLong().longValue());
        }
        strategyMap = new MobileAppCampaignStrategyMap()
                .withSearch(new MobileAppCampaignSearchStrategyMap()
                        .withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.AVERAGE_CPI)
                        .withAverageCpi(params
                                .withAverageCpi(averageCpi.bidLong().longValue())))
                .withNetwork(new MobileAppCampaignNetworkStrategyMap().defaultNetworkDefault());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1052")
    public void priceCombinationsTest() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withMobileAppCampaign(new MobileAppCampaignUpdateItemMap()
                                .withBiddingStrategy(strategyMap))),
                expectedResult.apply(campaignId));
    }
}
