package ru.yandex.autotests.direct.api.campaigns.update.mobilecampaign.strategy.maximumappinstalls;

import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.beans.campaign.StrategyData;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStrategyName;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumAppInstallsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.api.campaigns.CampaignCommonMatchers.strategyDataCompareStrategy;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка сохранения в базу стратегии WbMaximumAppInstalls")
@Issue("https://st.yandex-team.ru/DIRECT-70914")
@Tag(TagDictionary.TRUNK)
public class StrategyWbMaximumAppInstallsDbTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;
    private static final Currency CURRENCY = Currency.RUB;

    private static final Money BID_CEILING = MoneyCurrency.get(CURRENCY).getMinAveragePrice().getNext();
    private static final Money WEEKLY_SPEND_LIMIT =
            MoneyCurrency.get(CURRENCY).getMaxWeeklyBudgetAmount().divide(10f);
    private static final Long GOAL_ID = 4L;

    private Long cid;
    private int shard;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    @Step("Подготовим данные для теста")
    public void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        cid = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(cid)
                        .withMobileAppCampaign(new MobileAppCampaignUpdateItemMap()
                                .withBiddingStrategy(new MobileAppCampaignStrategyMap()
                                        .withSearch(new MobileAppCampaignSearchStrategyMap()
                                                .withBiddingStrategyType(
                                                        MobileAppCampaignSearchStrategyTypeEnum.WB_MAXIMUM_APP_INSTALLS)
                                                .withWbMaximumAppInstalls(new StrategyMaximumAppInstallsMap()
                                                        .withWeeklySpendLimit(WEEKLY_SPEND_LIMIT.bidLong().longValue())
                                                        .withBidCeiling(BID_CEILING.bidLong().longValue())))
                                        .withNetwork(
                                                new MobileAppCampaignNetworkStrategyMap().defaultServingOff())))),
                ExpectedResult.success());
    }

    @Test
    public void saveInDbTest() {
        CampaignsRecord campaignsRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(cid);
        CampaignsRecord expextedCampaignsRecord = new CampaignsRecord();
        expextedCampaignsRecord.setCid(cid);
        expextedCampaignsRecord.setStrategyName(CampaignsStrategyName.autobudget);
        expextedCampaignsRecord.setStrategyData(new StrategyData()
                .withSum(WEEKLY_SPEND_LIMIT.doubleValue())
                .withBid(BID_CEILING.doubleValue())
                .withName(CampaignsStrategyName.autobudget)
                .withGoalId(GOAL_ID.toString())
                .withVersion(1)
                .toJsonElement());
        assertThat("стратегия правильно сохранилась в базе", campaignsRecord.intoMap(),
                beanDiffer(expextedCampaignsRecord.intoMap())
                        .useCompareStrategy(strategyDataCompareStrategy));
    }
}
