package ru.yandex.autotests.direct.api.campaigns.update.mobilecampaign.strategy.networkdefault;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyNetworkDefaultAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.CoreMatchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by gerdler on 26.02.2019.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-92407")
@RunWith(Parameterized.class)
@Description("Проверка получения предупреждений при указании параметров LimitPercent и BidPercent"
        + " при обновлении кампании со стратегией NetworkDefault и конверсионной стратегией на поиске")
public class StrategyNetworkDefaultAndConversionOnSearchTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private Long campaignId;

    private MobileAppCampaignStrategyMap strategyMap;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String searchStrategyDescription;

    @Parameterized.Parameter(value = 1)
    public MobileAppCampaignSearchStrategyMap newSearchStrategy;

    @Parameterized.Parameters(name = "search = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {"AverageCpi", new MobileAppCampaignSearchStrategyMap().defaultAverageCpi(currency)},
                {"WbMaximumAppInstalls",
                        new MobileAppCampaignSearchStrategyMap().defaultWbMaximumAppInstalls(currency)},
                {"AverageCpc", new MobileAppCampaignSearchStrategyMap().defaultAverageCpc(currency)},
        };
        return Arrays.asList(data);
    }

    private static DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(client);

    @Before
    @Step("Подготовим данные для теста")
    public void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        strategyMap = new MobileAppCampaignStrategyMap()
                .withSearch(newSearchStrategy)
                .withNetwork(new MobileAppCampaignNetworkStrategyMap().defaultNetworkDefaultWithLimitPercent());
    }

    @Test
    public void changeStrategyTest() {
        CampaignsRecord originalCampaignsRecord = jooqDbSteps.campaignsSteps().getCampaignById(campaignId);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withMobileAppCampaign(new MobileAppCampaignUpdateItemMap()
                                .withBiddingStrategy(strategyMap)
                                .withSettings(
                                        new MobileAppCampaignSettingMap()
                                                .withOption(MobileAppCampaignSettingsEnum.MAINTAIN_NETWORK_CPC)
                                                .withValue(YesNoEnum.NO)
                                )
                        )),
                ExpectedResult.warnings(campaignId,
                        new Notification(10165, Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED, capitalize(
                                StrategyNetworkDefaultAddMap.LIMIT_PERCENT)),
                        new Notification(10163, Api5ErrorDetails.SETTING_WILL_NOT_BE_CHANGED,
                                TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC)
                )
        );
        CampaignsRecord newCampaignRecord = jooqDbSteps.campaignsSteps().getCampaignById(campaignId);
        assertThat("ContextLimit не изменился", newCampaignRecord.getContextlimit(),
                equalTo(originalCampaignsRecord.getContextlimit()));
        assertThat("ContextPriceCoef не изменился", newCampaignRecord.getContextpricecoef(),
                equalTo(originalCampaignsRecord.getContextpricecoef()));
        /* Ранее в перле флаг заполнялся, но эту логику изменили в java
        assertThat("opts не изменился", newCampaignRecord.getOpts(),
                equalTo("no_title_substitute"));
        */
    }
}
