package ru.yandex.autotests.direct.api.campaigns.update.mobilecampaign.strategy.networkdefault;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignNetworkStrategy;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignStrategy;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyNetworkDefaultAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyNetworkDefaultMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 06.10.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Проверка допустимых комбинаций параметров LimitPercent и BidPercent при обновлении кампании со " +
        "стратегией NetworkDefault")
@Tag(TagDictionary.TRUNK)
public class StrategyNetworkDefaultTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private Long campaignId;

    private MobileAppCampaignStrategyMap strategyMap;

    private MobileAppCampaignNetworkStrategyMap expectedContextStrategyMap;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String searchStrategyDescription;

    @Parameterized.Parameter(value = 1)
    public Integer limitPercent;

    @Parameterized.Parameter(value = 2)
    public MobileAppCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameters(name = "search = {0}, limit = {1}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                //Ручная стратегия на Search
                {"Ручная", null,
                        new MobileAppCampaignSearchStrategyMap().defaultAverageCpc(currency)},
                {"Ручная", 40,
                        new MobileAppCampaignSearchStrategyMap().defaultAverageCpc(currency)},
                {"Ручная", 10,
                        new MobileAppCampaignSearchStrategyMap().defaultAverageCpc(currency)},
                {"Ручная", 100,
                        new MobileAppCampaignSearchStrategyMap().defaultAverageCpc(currency)},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        strategyMap = new MobileAppCampaignStrategyMap()
                .withSearch(searchStrategy)
                .withNetwork(new MobileAppCampaignNetworkStrategyMap()
                        .withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT)
                        .withNetworkDefault(new StrategyNetworkDefaultMap()
                                .withLimitPercent(limitPercent)));
        expectedContextStrategyMap = new MobileAppCampaignNetworkStrategyMap()
                .withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1064")
    public void networkDefaultTest() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withMobileAppCampaign(new MobileAppCampaignUpdateItemMap()
                                .withBiddingStrategy(strategyMap))),
                // Указывать для автобюджетных стратегий LimitPercent не имеет смысла
                limitPercent == null
                        ? JavaOrPerlExpectedResult
                        .java(ExpectedResult.success(campaignId))
                        .perl(ExpectedResult.warnings(
                                new Notification(10165, Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED,
                                        capitalize(StrategyNetworkDefaultAddMap.LIMIT_PERCENT)),
                                new Notification(10163, Api5ErrorDetails.SETTING_WILL_NOT_BE_CHANGED,
                                        TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC)))

                        : JavaOrPerlExpectedResult
                        .java(ExpectedResult.warnings(
                                new Notification(10165, Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED,
                                        capitalize(StrategyNetworkDefaultAddMap.LIMIT_PERCENT))))
                        .perl(ExpectedResult.warnings(
                                new Notification(10165, Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED,
                                        capitalize(StrategyNetworkDefaultAddMap.LIMIT_PERCENT)),
                                new Notification(10163, Api5ErrorDetails.SETTING_WILL_NOT_BE_CHANGED,
                                        TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC))));

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                                .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withMobileAppCampaignFieldNames(MobileAppCampaignFieldEnum.BIDDING_STRATEGY));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        MobileAppCampaignStrategy actualStrategy = campaigns.get(0).getMobileAppCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        assertThat("получили корректную стратегию для Network", actualStrategy.getNetwork(),
                beanDifferV5((MobileAppCampaignNetworkStrategy) expectedContextStrategyMap.getBean()));
    }
}
