package ru.yandex.autotests.direct.api.campaigns.update.mobilecampaign.strategy.payforinstall;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyPayForInstallAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyPayForInstallMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.both;

/*
 * Тест работает с включенными фичами cpa_pay_for_conversions_mobile_apps_allowed и
 * cpa_pay_for_conversions_extended_mode
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Негативные сценарии проверки при обновлении стратегии PayForInstall")
@Tag(TagDictionary.TRUNK)
//todo после появления переводов в танкере обновить переводы в монге
public class StrategyPayForInstallNegativeTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static final Money minWeeklyBudgetAmount = MoneyCurrency.get(currency).getMinWeeklyBudgetAmount();
    private static final MoneyCurrency moneyCurrency = MoneyCurrency.get(currency);
    private static final Money minPrice = moneyCurrency.getMinAveragePrice();
    private static final Money maxPrice = moneyCurrency.getMaxPayForConversionCpa();

    private static final int PAY_FOR_INSTALL_SUM_TO_AVG_CPA_MIN_RATIO = 20;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public StrategyPayForInstallMap params;

    @Parameterized.Parameter(value = 2)
    public JavaOrPerlExpectedResult expectedResult;
    private Long campaignId;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {"Нулевое значение", new StrategyPayForInstallMap().withAverageCpi(0L),
                        both(ExpectedResult.errorsIgnoringDetails(new Notification(4000, Api5ErrorDetails.AVERAGE_CPI_SHOULD_BE_MORE_THAN,
                                minPrice.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription())))},
                {"Отрицательное значение", new StrategyPayForInstallMap().withAverageCpi(-1L),
                        both(ExpectedResult.errorsIgnoringDetails(new Notification(4000, Api5ErrorDetails.AVERAGE_CPI_SHOULD_BE_MORE_THAN,
                                minPrice.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription())))},
                {"Значение меньше минимального",
                        new StrategyPayForInstallMap().withAverageCpi(minPrice.getPrevious().bidLong().longValue()),
                        both(ExpectedResult.errorsIgnoringDetails(new Notification(4000, Api5ErrorDetails.AVERAGE_CPI_SHOULD_BE_MORE_THAN,
                                minPrice.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription())))},
                {"Значение больше максимального",
                        new StrategyPayForInstallMap().withAverageCpi(
                                // умножаем на 3, потому что включена фича increased_cpa_limit_for_pay_for_conversion
                                maxPrice.multiply(3).getNext().bidLong().longValue()),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(
                                        new Notification(4000,
                                                Api5ErrorDetailsJava.MUST_BE_LESS_THAN_OR_EQUAL_TO_WEEKLY_BUDGET,
                                                "AverageCpi"),
                                        new Notification(4000,
                                                Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_GREATER_THAN,
                                                "AverageCpi",
                                                maxPrice.multiply(3).stringValue(MoneyFormat.WITHOUT_EXTRA_ZEROS))))
                                .perl(ExpectedResult.errors(new Notification(4000,
                                        Api5ErrorDetails.AVERAGE_CPI_SHOULD_BE_NO_MORE_THAN,
                                        maxPrice.multiply(3).stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                        moneyCurrency.getApiDescription())))},
                {"Среднее значение ставки больше недельного бюджета",
                        new StrategyPayForInstallMap()
                                .withAverageCpi(
                                        MoneyCurrency.get(currency).getMinWeeklyBudgetAmount().getNext().bidLong()
                                                .longValue())
                                .withWeeklySpendLimit(
                                MoneyCurrency.get(currency).getMinWeeklyBudgetAmount().bidLong().longValue()),
                        both(ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.WEEKLY_BUDGET_SHOULD_BE_GREATER_THAN_AVERAGE_CPI)))},
                // Чиним в DIRECT-161540
//                {"Среднее значение ставки * 20 больше недельного бюджета",
//                        new StrategyPayForInstallMap()
//                                .withAverageCpi(minWeeklyBudgetAmount.divide(20).getNext().bidLong().longValue())
//                                .withWeeklySpendLimit(minWeeklyBudgetAmount.bidLong().longValue()),
//                        ExpectedResult.errors(new Notification(4000,
//                                Api5ErrorDetails.WEEKLY_BUDGET_MUST_BE_GREATER_THAN_AVG_CPA_MULTIPLIED_BY_RATIO,
//                                PAY_FOR_INSTALL_SUM_TO_AVG_CPA_MIN_RATIO))},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);

        AddResponse response = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withMobileAppCampaign(new MobileAppCampaignAddItemMap()
                                .withBiddingStrategy(new MobileAppCampaignStrategyAddMap()
                                        .withSearch(new MobileAppCampaignSearchStrategyAddMap()
                                                .withBiddingStrategyType(
                                                        MobileAppCampaignSearchStrategyTypeEnum.PAY_FOR_INSTALL)
                                                .withPayForInstall(new StrategyPayForInstallAddMap()
                                                        .withAverageCpi(minWeeklyBudgetAmount.divide(20).bidLong()
                                                                .longValue())
                                                        .withWeeklySpendLimit(minWeeklyBudgetAmount.bidLong()
                                                                .longValue())))
                                        .withNetwork(new MobileAppCampaignNetworkStrategyAddMap()
                                                .defaultServingOff())))),
                ExpectedResult.success());

        campaignId = response.getAddResults().get(0).getId();
    }

    @Test
    public void payForInstallNegativeTest() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withMobileAppCampaign(new MobileAppCampaignUpdateItemMap()
                                .withBiddingStrategy(new MobileAppCampaignStrategyMap()
                                        .withSearch(new MobileAppCampaignSearchStrategyMap()
                                                .withBiddingStrategyType(
                                                        MobileAppCampaignSearchStrategyTypeEnum.PAY_FOR_INSTALL)
                                                .withPayForInstall(params))
                                        .withNetwork(new MobileAppCampaignNetworkStrategyMap()
                                                .defaultNetworkDefault())))),
                expectedResult);
    }
}
