package ru.yandex.autotests.direct.api.campaigns.update.negativekeywords;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampOptionsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.cases.MinusWordsStorageCases;
import ru.yandex.autotests.directapi.converters.MinusWordsSerializer;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.junit.Assert.assertThat;

/**
 * Created by andy-ilyin on 13.09.16.
 * https://st.yandex-team.ru/TESTIRT-10213
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/DIRECT-55547")
@Description("Проверка работы метода с новым JSON форматом минус-слов")
@RunWith(Parameterized.class)
public class NegativeKeywordsStorageTest {
    private static Long campaignId;
    private static DirectJooqDbSteps dbSteps;
    private static final MinusWordsSerializer minusWordSerializer = MinusWordsSerializer.CURRENT_SERIALIZER;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CampaignsLogins.UPDATE_CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public String description;

    @Parameterized.Parameter(1)
    public String[] negativeKeywords;

    @Parameterized.Parameter(2)
    public String[] normalizedNegativeKeywords;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testData() {
        List<Object[]> result = new LinkedList<>();
        for (MinusWordsStorageCases.TestCase testCase : MinusWordsStorageCases.getTestCases()) {
            result.add(new Object[]{
                    testCase.getDescription(),
                    testCase.getMinusWords().toArray(new String[]{}),
                    testCase.getNormalizedMinusWords().toArray(new String[]{})
            });
        }
        return result;
    }

    @BeforeClass
    public static void createCampaignAndAdGroup() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CampaignsLogins.UPDATE_CLIENT);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CampaignsLogins.UPDATE_CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1078")
    public void testNegativeKeywordStorage() {
        api.userSteps.campaignSteps().campaignsUpdate(
                new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(campaignId)
                                        .withNegativeKeywords(negativeKeywords)
                        ));

        CampOptionsRecord campOptionsRecord = dbSteps.campaignsSteps().getCampOptionsById(campaignId);

        assertThat("получены ожидаемые минус-слова",
                minusWordSerializer.read(campOptionsRecord.getMinusWords()),
                containsInAnyOrder(normalizedNegativeKeywords));
    }
}
