package ru.yandex.autotests.direct.api.campaigns.update.notification;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.SmsEventsEnum;
import com.yandex.direct.api.v5.campaigns.SmsSettings;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.NotificationMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmsSettingsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by semkagtn on 03.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка сохранения значений из структуры Notification.SmsSettings при обновлении поля Events")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class SmsSettingsSaveToDatabaseEventsTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public List<SmsEventsEnum> events;

    @Parameterized.Parameters(name = "Events = {0}")
    public static Iterable<Object[]> data() {
        List<Object[]> parameters = Stream.of(SmsEventsEnum.values())
                .map(x -> new Object[]{Arrays.asList(x)})
                .collect(Collectors.toList());
        parameters.add(new Object[]{Arrays.asList(SmsEventsEnum.MODERATION, SmsEventsEnum.MONEY_IN)});
        return parameters;
    }

    private long campaignId;

    @Before
    @Step("Подготовка данных для теста")
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        campaignId = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withNotification(new NotificationMap()
                                .defaultNotification()
                                .withSmsSettings(new SmsSettingsMap()
                                        .withEvents(SmsEventsEnum.MONEY_OUT, SmsEventsEnum.FINISHED)
                                        .withTimeFrom(SmsSettingsMap.VALID_TIME_FROM)
                                        .withTimeTo(SmsSettingsMap.VALID_TIME_TO)))
                        .withDefaultTextCampaign());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1085")
    public void saveNotificationToDatabase() {
        SmsSettingsMap smsSettingsMap = new SmsSettingsMap()
                .withEvents(events.toArray(new SmsEventsEnum[events.size()]));
        api.userSteps.campaignSteps().campaignsUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withNotification(new NotificationMap()
                                .withSmsSettings(smsSettingsMap))));
        CampaignGetItem campaign =
                api.userSteps.campaignSteps().campaignsGet(campaignId, CampaignFieldEnum.NOTIFICATION);
        SmsSettings smsSettings = campaign.getNotification().getSmsSettings();
        assumeThat("получена структура SmsSettings", smsSettings, notNullValue());
        assertThat("значение events было сохранено верно", smsSettings,
                beanDiffer(smsSettingsMap
                        .withTimeFrom(SmsSettingsMap.VALID_TIME_FROM)
                        .withTimeTo(SmsSettingsMap.VALID_TIME_TO).getBean()));
    }
}
