package ru.yandex.autotests.direct.api.campaigns.update.notification;

import java.util.Arrays;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.NotificationMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmsSettingsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 03.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка валидации полей TimeFrom, TimeTo в настройках смс-нотификаций кампании при её обновлении")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@RunWith(Parameterized.class)
public class SmsSettingsTimeFromTimeToValidationTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String timeFrom;

    @Parameterized.Parameter(2)
    public String timeTo;

    @Parameterized.Parameter(3)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}: TimeFrom = {1}, TimeTo = {2}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Минимальное значение TimeFrom", "00:00", "20:00", JavaOrPerlExpectedResult.both(
                        ExpectedResult.success())},
                {"Максимальное значение TimeTo", "05:00", "24:00", JavaOrPerlExpectedResult.both(
                        ExpectedResult.success())},
                {"Равные значение TimeFrom и TimeTo", "07:00", "07:00", JavaOrPerlExpectedResult.both(
                        ExpectedResult.success())},
                {"15 минут в TimeFrom", "07:15", "09:00", JavaOrPerlExpectedResult.both(ExpectedResult.success())},
                {"30 минут в TimeFrom", "07:30", "09:00", JavaOrPerlExpectedResult.both(ExpectedResult.success())},
                {"45 минут в TimeFrom", "07:45", "09:00", JavaOrPerlExpectedResult.both(ExpectedResult.success())},
                {"15 минут в TimeTo", "07:00", "09:15", JavaOrPerlExpectedResult.both(ExpectedResult.success())},
                {"30 минут в TimeTo", "07:00", "09:30", JavaOrPerlExpectedResult.both(ExpectedResult.success())},
                {"45 минут в TimeTo", "07:00", "09:45", JavaOrPerlExpectedResult.both(ExpectedResult.success())},
                {"TimeFrom > TimeTo (переход через полночь)", "07:00", "06:00",
                        JavaOrPerlExpectedResult.both(ExpectedResult.success())},//DIRECT-47227
                {"Невалидный формат в TimeFrom", "03:00.0", "06:00", JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "TimeFrom")))
                        .perl(ExpectedResult.errors(new Notification(5004, Api5ErrorDetails.INVALID_TIME_FROM)))},
                {"Невалидный формат в TimeTo", "03:00", "06:00.0", JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.VALUE_INVALID_FORMAT_IN_FILED, "TimeTo")))
                        .perl(ExpectedResult.errors(new Notification(5004, Api5ErrorDetails.INVALID_TIME_TO)))},
                {"25 часов в TimeTo", "03:00", "25:00", JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.VALUE_INVALID_FORMAT_IN_FILED, "TimeTo")))
                        .perl(ExpectedResult.errors(new Notification(5004, Api5ErrorDetails.INVALID_TIME_TO)))},
                {"60 минут в TimeFrom", "03:60", "23:00", JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.VALUE_INVALID_FORMAT_IN_FILED, "TimeFrom")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                        Api5ErrorDetails.INVALID_TIME_FROM)))
                },
                {"60 минут в TimeTo", "03:00", "23:60", JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.VALUE_INVALID_FORMAT_IN_FILED, "TimeTo")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                        Api5ErrorDetails.INVALID_TIME_TO)))
                },
                {"Неверные минуты (17 минут) в TimeFrom", "03:17", "22:00", JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.VALUE_INVALID_FORMAT_IN_FILED, "TimeFrom")))
                        .perl(ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.MINUTES_START_SHOULD_DIV_BY_15)))
                },
                {"Неверные минуты (17 минут) в TimeTo", "03:00", "22:17", JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.VALUE_INVALID_FORMAT_IN_FILED, "TimeTo")))
                        .perl(ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.MINUTES_END_SHOULD_DIV_BY_15)))
                },
        });
    }

    private long campaignId;

    @Before
    @Step("Подготовка данных для теста")
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1086")
    public void updateCampaignWithNotificationTimeFromTimeTo() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withNotification(new NotificationMap()
                                .defaultNotification()
                                .withSmsSettings(new SmsSettingsMap()
                                        .defaultSmsSettings()
                                        .withTimeFrom(timeFrom)
                                        .withTimeTo(timeTo)))),
                expectedResult);
    }
}
