package ru.yandex.autotests.direct.api.campaigns.update.notification;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.SmsEventsEnum;
import com.yandex.direct.api.v5.campaigns.SmsSettings;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.NotificationMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmsSettingsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Обновление Events без указания SmsSettings")
@Issue("https://st.yandex-team.ru/DIRECT-161077")
public class UpdateEventsInSmsSettingsWithoutTimesTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;
    private static final SmsEventsEnum[] OLD_EVENTS = {SmsEventsEnum.MONEY_OUT, SmsEventsEnum.FINISHED};
    private static final SmsEventsEnum[] NEW_EVENTS = {SmsEventsEnum.MONEY_OUT, SmsEventsEnum.MODERATION};
    private static final SmsEventsEnum[] EMPTY_EVENTS = {};

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long id;

    @Before
    @Step("Подготовка данных для теста")
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        id = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withNotification(new NotificationMap()
                                .defaultNotification()
                                .withSmsSettings(new SmsSettingsMap()
                                        .withEvents(OLD_EVENTS)
                                        .withTimeFrom(SmsSettingsMap.VALID_TIME_FROM)
                                        .withTimeTo(SmsSettingsMap.VALID_TIME_TO)))
                        .withDefaultTextCampaign());
    }

    @Test
    @Description("Передаём Events. Проверяем что Events сохранились, а timeFrom и timeTo не изменились")
    public void saveNotification() {
        SmsSettingsMap smsSettingsMap = new SmsSettingsMap()
                .withEvents(NEW_EVENTS);
        api.userSteps.campaignSteps().campaignsUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(id)
                        .withNotification(new NotificationMap()
                                .withSmsSettings(smsSettingsMap))));
        CampaignGetItem campaign = api.userSteps.campaignSteps().campaignsGet(id, CampaignFieldEnum.NOTIFICATION);

        smsSettingsMap = new SmsSettingsMap().withEvents(NEW_EVENTS)
                .withTimeFrom(SmsSettingsMap.VALID_TIME_FROM)
                .withTimeTo(SmsSettingsMap.VALID_TIME_TO);

        SmsSettings actualSmsSettings = campaign.getNotification().getSmsSettings();
        assumeThat("получена структура SmsSettings", actualSmsSettings, notNullValue());

        assertThat("значение events обновилось, а timeFrom и timeTo не изменились", actualSmsSettings,
                beanDiffer(smsSettingsMap.getBean()));
    }


    @Test
    @Description("Передаём пустой массив Events. Проверяем что ничего не поменялось (events не затёрилсь, " +
            "timeFrom, timeTo тоже сохранились)")
    public void saveNotificationEmptyEvents() {
        SmsSettingsMap smsSettingsMap = new SmsSettingsMap()
                .withEvents(EMPTY_EVENTS);
        api.userSteps.campaignSteps().campaignsUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(id)
                        .withNotification(new NotificationMap()
                                .withSmsSettings(smsSettingsMap))));
        CampaignGetItem campaign = api.userSteps.campaignSteps().campaignsGet(id, CampaignFieldEnum.NOTIFICATION);

        smsSettingsMap = new SmsSettingsMap().withEvents(OLD_EVENTS)
                .withTimeFrom(SmsSettingsMap.VALID_TIME_FROM)
                .withTimeTo(SmsSettingsMap.VALID_TIME_TO);

        SmsSettings actualSmsSettings = campaign.getNotification().getSmsSettings();
        assumeThat("получена структура SmsSettings", actualSmsSettings, notNullValue());

        assertThat("значение events, timeFrom и timeTo не изменились", actualSmsSettings,
                beanDiffer(smsSettingsMap.getBean()));
    }

}
