package ru.yandex.autotests.direct.api.campaigns.update.notification;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.SmsEventsEnum;
import com.yandex.direct.api.v5.campaigns.SmsSettings;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.NotificationMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmsSettingsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 12.01.16.
 * https://st.yandex-team.ru/TESTIRT-8165
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Обновление SmsSettings без указания Events")
@Issue("https://st.yandex-team.ru/DIRECT-49289")
public class UpdateTimesInSmsSettingsWithoutEventsTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;
    private static final String NEW_TIME_FROM = "04:15";
    public static final String NEW_TIME_TO = "15:30";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long id;

    @Before
    @Step("Подготовка данных для теста")
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        id = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withNotification(new NotificationMap()
                                .defaultNotification()
                                .withSmsSettings(new SmsSettingsMap()
                                        .withEvents(SmsEventsEnum.MONEY_OUT, SmsEventsEnum.FINISHED)
                                        .withTimeFrom(SmsSettingsMap.VALID_TIME_FROM)
                                        .withTimeTo(SmsSettingsMap.VALID_TIME_TO)))
                        .withDefaultTextCampaign());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1087")
    public void saveNotification() {
        SmsSettingsMap smsSettingsMap = new SmsSettingsMap()
                .withTimeFrom(NEW_TIME_FROM)
                .withTimeTo(NEW_TIME_TO);
        api.userSteps.campaignSteps().campaignsUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(id)
                        .withNotification(new NotificationMap()
                                .withSmsSettings(smsSettingsMap))));
        CampaignGetItem campaign = api.userSteps.campaignSteps().campaignsGet(id, CampaignFieldEnum.NOTIFICATION);

        smsSettingsMap = new SmsSettingsMap().withEvents(SmsEventsEnum.MONEY_OUT, SmsEventsEnum.FINISHED)
                .withTimeFrom(NEW_TIME_FROM)
                .withTimeTo(NEW_TIME_TO);

        SmsSettings actualSmsSettings = campaign.getNotification().getSmsSettings();
        assumeThat("получена структура SmsSettings", actualSmsSettings, notNullValue());

        assertThat("значение events было сохранено верно", actualSmsSettings,
                beanDiffer(smsSettingsMap.getBean()));
    }

    @Test
    @Ignore("разигнорить когда перейдём на Java")
    @Description("Передаём новое значение для TimeFrom, а TimeTo не меняем")
    public void saveNotificationTimeFrom() {
        SmsSettingsMap smsSettingsMap = new SmsSettingsMap()
                .withTimeFrom(NEW_TIME_FROM);
        api.userSteps.campaignSteps().campaignsUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(id)
                        .withNotification(new NotificationMap()
                                .withSmsSettings(smsSettingsMap))));
        CampaignGetItem campaign = api.userSteps.campaignSteps().campaignsGet(id, CampaignFieldEnum.NOTIFICATION);

        smsSettingsMap = new SmsSettingsMap().withEvents(SmsEventsEnum.MONEY_OUT, SmsEventsEnum.FINISHED)
                .withTimeFrom(NEW_TIME_FROM)
                .withTimeTo(SmsSettingsMap.VALID_TIME_TO);

        SmsSettings actualSmsSettings = campaign.getNotification().getSmsSettings();
        assumeThat("получена структура SmsSettings", actualSmsSettings, notNullValue());

        assertThat("значение events было сохранено верно", actualSmsSettings,
                beanDiffer(smsSettingsMap.getBean()));
    }


    @Test
    @Ignore("разигнорить когда перейдём на Java")
    @Description("Передаём новое значение для TimeTo, а TimeFrom не меняем")
    public void saveNotificationTimeTo() {
        SmsSettingsMap smsSettingsMap = new SmsSettingsMap()
                .withTimeTo(NEW_TIME_TO);
        api.userSteps.campaignSteps().campaignsUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(id)
                        .withNotification(new NotificationMap()
                                .withSmsSettings(smsSettingsMap))));
        CampaignGetItem campaign = api.userSteps.campaignSteps().campaignsGet(id, CampaignFieldEnum.NOTIFICATION);

        smsSettingsMap = new SmsSettingsMap().withEvents(SmsEventsEnum.MONEY_OUT, SmsEventsEnum.FINISHED)
                .withTimeFrom(SmsSettingsMap.VALID_TIME_FROM)
                .withTimeTo(NEW_TIME_TO);

        SmsSettings actualSmsSettings = campaign.getNotification().getSmsSettings();
        assumeThat("получена структура SmsSettings", actualSmsSettings, notNullValue());

        assertThat("значение events было сохранено верно", actualSmsSettings,
                beanDiffer(smsSettingsMap.getBean()));
    }

}
