package ru.yandex.autotests.direct.api.campaigns.update.smartcampaign;

import com.yandex.direct.api.v5.campaigns.SmartCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.SmartCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsArrayMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsUpdateSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageRoiAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;


@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-109983")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка сброса поля PriorityGoals при использовании в стратегии roi оптимизации по КЦ")
public class UnsetPriorityGoalsUsingInStrategyNegativeTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;
    private static Long cid;

    private static final Integer COUNTER_ID = 34981090;
    private static final Long GOAL_ID = 17108070L;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);

        cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withSmartCampaign(new SmartCampaignAddItemMap()
                        .withBiddingStrategy(new SmartCampaignStrategyAddMap()
                                .defaultSmartCampaignStrategy()
                                .withSearch(new SmartCampaignSearchStrategyAddMap()
                                        .withBiddingStrategyType(SmartCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                                        .withAverageRoi(new StrategyAverageRoiAddMap()
                                                .defaultStrategyAverageRoi()
                                                .withGoalId(13L)))
                                .withNetwork(new SmartCampaignNetworkStrategyAddMap()
                                        .withBiddingStrategyType(SmartCampaignNetworkStrategyTypeEnum.SERVING_OFF)))
                        .withCounterId(Long.valueOf(COUNTER_ID))
                        .withPriorityGoals(new PriorityGoalsArrayMap()
                                .withItems(new PriorityGoalsItemMap()
                                        .withGoalId(GOAL_ID)
                                        .withValue(1_000_000L)))));
    }

    @Test
    public void unsetPriorityGoalsUsingInStrategy() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(cid)
                                .withSmartCampaign(new SmartCampaignUpdateItemMap()
                                        .withPriorityGoals((PriorityGoalsUpdateSettingMap) null)
                                )
                        ),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.NOT_SUITABLE_MEANINGFUL_GOALS)))
                        .perl(ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.MEANINGFUL_GOALS_CANNOT_BE_UNSET))));
    }

    @Test
    public void unsetPriorityGoalsAndConter() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(cid)
                                .withSmartCampaign(new SmartCampaignUpdateItemMap()
                                        .withCounterId((Long) null)
                                        .withPriorityGoals((PriorityGoalsUpdateSettingMap) null)
                                )
                        ),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.NOT_SUITABLE_MEANINGFUL_GOALS)))
                        .perl(ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.MEANINGFUL_GOALS_CANNOT_BE_UNSET))));
    }
}
