package ru.yandex.autotests.direct.api.campaigns.update.smartcampaign;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.campaigns.SmartCampaignFieldEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsArrayMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsUpdateSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;


@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-109983")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка обновления поля PriorityGoals. Проверка заполнения null")
@RunWith(Parameterized.class)
public class UpdatePriorityGoalsNillableTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;
    private static Long cid;
    private static Long counter = Long.valueOf(MetrikaGoals.getCounterForLogin(client));

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public ProtocolType protocolType;

    @Parameterized.Parameters(name = "protocol = {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {ProtocolType.JSON},
                {ProtocolType.SOAP}
        });
    }

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);

        PriorityGoalsItemMap priorityGoalsItemMap = new PriorityGoalsItemMap()
                .withEngagedSessionGoalId()
                .withValue(1_000_000L);
        PriorityGoalsArrayMap priorityGoalsArrayMap = new PriorityGoalsArrayMap()
                .withItems(priorityGoalsItemMap);

        cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withSmartCampaign(new SmartCampaignAddItemMap()
                        .withBiddingStrategy(new SmartCampaignStrategyAddMap()
                                .defaultSmartCampaignStrategy())
                        .withCounterId(counter)
                        .withPriorityGoals(priorityGoalsArrayMap)));

        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(cid)
                        )
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withSmartCampaignFieldNames(SmartCampaignFieldEnum.PRIORITY_GOALS));

        priorityGoalsItemMap.withIsMetrikaSourceOfValue(YesNoEnum.NO);

        assumeThat("вернулось установленное значение PriorityGoals", getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList((CampaignGetItem) new CampaignGetItemMap()
                        .withId(cid)
                        .withSmartCampaign(
                                new SmartCampaignGetItemMap().withPriorityGoals(priorityGoalsArrayMap)
                        ).getBean())));
    }

    @Test
    public void updateWithEmptyGoals() {
        api.protocol(protocolType);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(cid)
                                .withSmartCampaign(new SmartCampaignUpdateItemMap()
                                        .withPriorityGoals((PriorityGoalsUpdateSettingMap) null)
                                )
                        ),
                ExpectedResult.success());

        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(cid)
                        )
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withSmartCampaignFieldNames(SmartCampaignFieldEnum.PRIORITY_GOALS));

        assertThat("вернулся пустой параметр PriorityGoals", getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList((CampaignGetItem) new CampaignGetItemMap()
                        .withId(cid)
                        .withSmartCampaign(
                                new SmartCampaignGetItemMap().withPriorityGoals((PriorityGoalsArrayMap) null)
                        ).getBean())));
    }
}
