package ru.yandex.autotests.direct.api.campaigns.update.smartcampaign.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.campaigns.SmartCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.SmartCampaignSettingGet;
import com.yandex.direct.api.v5.campaigns.SmartCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaigns.SmartCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignSettingGetMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-109983")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка поля Settings. Независимость изменений с NO на YES")
@RunWith(Parameterized.class)
public class UpdateAndGetSettingsAllNoTest {
    private static String client = CampaignsLogins.CLIENT;
    private static Integer counter = MetrikaGoals.getCounterForLogin(client);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private Long campaignID;
    private List<SmartCampaignSettingGet> expectedSettings;
    @Rule
    public Trashman trasher = new Trashman(api);

    private static Set<String> getDeprecatedSetting() {
        Set<String> deprecatedSetting = new HashSet<>();

        deprecatedSetting.add(SmartCampaignSettingsEnum.REQUIRE_SERVICING.toString());

        return deprecatedSetting;
    }

    @Parameterized.Parameter(0)
    public SmartCampaignSettingsEnum option;

    @Parameterized.Parameters(name = "option = {0}")
    public static Collection testData() {
        Set<String> deprecatedSetting = getDeprecatedSetting();

        List<Object[]> data = new ArrayList<Object[]>();
        for (SmartCampaignSettingsEnum campaignSettingsEnum : SmartCampaignSettingsEnum.values()) {
            if (deprecatedSetting.contains(campaignSettingsEnum.toString())) {
                continue;
            }
            data.add(new Object[]{campaignSettingsEnum});
        }
        return data;
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareCampaign() {
        Set<String> deprecatedSetting = getDeprecatedSetting();

        expectedSettings = new ArrayList<>();
        for (SmartCampaignSettingsGetEnum campaignSettingsEnum : SmartCampaignSettingsGetEnum.values()) {
            expectedSettings.add((SmartCampaignSettingGet) new SmartCampaignSettingGetMap()
                    .withOption(campaignSettingsEnum)
                    .withValue((campaignSettingsEnum.value().equals(option.value()) ||
                            campaignSettingsEnum.equals(SmartCampaignSettingsGetEnum.DAILY_BUDGET_ALLOWED) ||
                            campaignSettingsEnum.equals(SmartCampaignSettingsGetEnum.ENABLE_AREA_OF_INTEREST_TARGETING)
                    ) ? YesNoEnum.YES : YesNoEnum.NO)
                    .getBean()
            );
        }

        ArrayList<SmartCampaignSettingMap> settings = new ArrayList<>();
        for (SmartCampaignSettingsEnum campaignSettingsEnum : SmartCampaignSettingsEnum.values()) {
            if (deprecatedSetting.contains(campaignSettingsEnum.toString())) {
                continue;
            }
            settings.add(new SmartCampaignSettingMap().withOption(campaignSettingsEnum)
                    .withValue(YesNoEnum.NO));
        }
        campaignID = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withSmartCampaign(new SmartCampaignAddItemMap()
                                .defaultSmartCampaign()
                                .withCounterId(Long.valueOf(counter))
                                .withSettings(settings.toArray(new SmartCampaignSettingMap[settings.size()]))
                        ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("949")
    public void checkUpdateSettingsTest() {
        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                .withId(campaignID)
                .withSmartCampaign(new SmartCampaignUpdateItemMap()
                        .withSettings(new SmartCampaignSettingMap()
                                .withOption(option)
                                .withValue(YesNoEnum.YES)))
        ));
        GetResponse getResponse = api.as(client).userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                                .withIds(campaignID))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withSmartCampaignFieldNames(SmartCampaignFieldEnum.SETTINGS));
        assumeThat("получили созданную кампанию", getResponse.getCampaigns(), hasSize(1));
        List<SmartCampaignSettingGet> settings =
                getResponse.getCampaigns().get(0).getSmartCampaign().getSettings();
        assumeThat("получили настройки кампании", settings, notNullValue());
        Collections.sort(settings, (o1, o2) -> o1.getOption().toString().compareTo(o2.getOption().toString()));
        Collections.sort(expectedSettings, (o1, o2) -> o1.getOption().toString().compareTo(o2.getOption().toString()));
        assumeThat("вернулся ожидаемый набор настроек", settings, beanDiffer(expectedSettings));
    }
}
