package ru.yandex.autotests.direct.api.campaigns.update.smartcampaign.strategy.payforconversion;

import com.yandex.direct.api.v5.campaigns.SmartCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpaPerCampaignMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyPayForConversionPerCampaignMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyPayForConversionPerFilterMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pashkus on 17.12.2020.
 * Тест работает с включенными фичей cpa_pay_for_conversions_extended_mode
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Cценарии проверки при обновлении стратегии c AverageCpa на PayForConversion")
@Tag(TagDictionary.TRUNK)

public class StrategyChangeFromAvgCpaToPayForConversion {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Integer counterId = 32265784;
    private static final Long goalId = MetrikaGoals.getGoalForCounter(counterId);
    private static final Money cpa = Money.valueOf(500);
    private static final Money weekSpendLimit = Money.valueOf(10000);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);
    private Long campaignId;

    @Before
    @Step("Подготовим данные для теста")
    public void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultSmartCampaign(client);
        int shard = api.userSteps.clientFakeSteps().getUserShard(client);

        DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        dbSteps.campMetrikaGoalsSteps()
                .addOrUpdateMetrikaGoals(campaignId, goalId.longValue(), 100L, 100L);

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withSmartCampaign(new SmartCampaignUpdateItemMap()
                                .withBiddingStrategy(new SmartCampaignStrategyMap()
                                        .withSearch(new SmartCampaignSearchStrategyMap()
                                                .withBiddingStrategyType(
                                                        SmartCampaignSearchStrategyTypeEnum.AVERAGE_CPA_PER_CAMPAIGN)
                                                .withAverageCpaPerCampaign(new StrategyAverageCpaPerCampaignMap()
                                                        .withGoalId(goalId)
                                                        .withAverageCpa(Money.valueOf(300).bidLong().longValue())
                                                        .withBidCeiling(Money.valueOf(2).bidLong().longValue())))
                                        .withNetwork(new SmartCampaignNetworkStrategyMap().defaultServingOff())))),
                ExpectedResult.success());
    }

    @Test
    public void changeStrategyToPayForConversionCpa() {
        checkAvgCpaBiddingStrategyUpdateRequest(
                getDefaultPayForConversionPerCampStrategy(),
                ExpectedResult.success());
    }

    private static StrategyPayForConversionPerCampaignMap getDefaultPayForConversionPerCampStrategy() {
        return new StrategyPayForConversionPerCampaignMap()
                .withWeeklySpendLimit(weekSpendLimit.bidLong().longValue())
                .withGoalId(goalId)
                .withCpa(cpa.bidLong().longValue());
    }

    private void checkAvgCpaBiddingStrategyUpdateRequest(StrategyPayForConversionPerCampaignMap strategyPayForConversionPerCampaignMap,
                                                         ExpectedResult expectedResult) {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withSmartCampaign(new SmartCampaignUpdateItemMap()
                                .withBiddingStrategy(new SmartCampaignStrategyMap()
                                        .withSearch(new SmartCampaignSearchStrategyMap()
                                                .withBiddingStrategyType(
                                                        SmartCampaignSearchStrategyTypeEnum.PAY_FOR_CONVERSION_PER_CAMPAIGN)
                                                .withPayForConversionPerCampaign(strategyPayForConversionPerCampaignMap))
                                        .withNetwork(new SmartCampaignNetworkStrategyMap().defaultServingOff())))),
                expectedResult);
    }

    @Test
    public void changeStrategyToPayForConversionPerFilter() {
        StrategyPayForConversionPerFilterMap payForConversionPerFilterStrategy =
                new StrategyPayForConversionPerFilterMap()
                        .withWeeklySpendLimit(weekSpendLimit.bidLong().longValue())
                        .withGoalId(goalId)
                        .withCpa(cpa.bidLong().longValue());
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withSmartCampaign(new SmartCampaignUpdateItemMap()
                                .withBiddingStrategy(new SmartCampaignStrategyMap()
                                        .withSearch(new SmartCampaignSearchStrategyMap()
                                                .withBiddingStrategyType(
                                                        SmartCampaignSearchStrategyTypeEnum.PAY_FOR_CONVERSION_PER_FILTER)
                                                .withPayForConversionPerFilter(payForConversionPerFilterStrategy))
                                        .withNetwork(new SmartCampaignNetworkStrategyMap().defaultServingOff())))),
                ExpectedResult.success());
    }
}
