package ru.yandex.autotests.direct.api.campaigns.update.smartcampaign.strategy.payforconversion;

import java.util.List;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.SmartCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.SmartCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.SmartCampaignStrategy;
import com.yandex.direct.api.v5.campaigns.UpdateResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpaPerCampaignMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyPayForConversionPerCampaignAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Тест работает с включенными фичей cpa_pay_for_conversions_extended_mode
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Cценарии проверки при обновлении стратегии c PayForConversion на AverageCpa")
@Tag(TagDictionary.TRUNK)
public class StrategyChangeFromPayForConversionToAverageCpaTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Integer counterId = MetrikaGoals.getCounterForLogin(client);
    private static final Money cpa = Money.valueOf(500);
    private static final Money weekSpendLimit = Money.valueOf(10000);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long[] goals = MetrikaGoals.getConterGoalIds(counterId, 1);
    @Rule
    public Trashman trasher = new Trashman(api);
    private Long campaignId;

    private SmartCampaignStrategyMap expectedStrategyMap;

    @Before
    @Step("Подготовим данные для теста")
    public void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);

        AddResponse response = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withSmartCampaign(new SmartCampaignAddItemMap()
                                .withCounterId(counterId.longValue())
                                .withBiddingStrategy(new SmartCampaignStrategyAddMap()
                                        .withSearch(new SmartCampaignSearchStrategyAddMap()
                                                .withBiddingStrategyType(SmartCampaignSearchStrategyTypeEnum.PAY_FOR_CONVERSION_PER_CAMPAIGN)
                                                .withPayForConversionPerCampaign(new StrategyPayForConversionPerCampaignAddMap()
                                                        .withCpa(cpa.getNext().bidLong().longValue())
                                                        .withGoalId(goals[0])
                                                        .withWeeklySpendLimit(null)))
                                        .withNetwork(new SmartCampaignNetworkStrategyAddMap().defaultServingOff())))),
                ExpectedResult.success());

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(response.getAddResults().get(0).getId()))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withSmartCampaignFieldNames(SmartCampaignFieldEnum.BIDDING_STRATEGY));


        assumeThat("получили результаты обновления кампании", response.getAddResults(), hasSize(1));
        campaignId = campaigns.get(0).getId();

        assumeThat("получили кампанию", campaigns, hasSize(1));
        SmartCampaignStrategy actualStrategy = campaigns.get(0).getSmartCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        expectedStrategyMap = new SmartCampaignStrategyMap()
                .withSearch(new SmartCampaignSearchStrategyMap()
                        .withBiddingStrategyType(SmartCampaignSearchStrategyTypeEnum.AVERAGE_CPA_PER_CAMPAIGN)
                        .withAverageCpaPerCampaign(new StrategyAverageCpaPerCampaignMap()
                                .withWeeklySpendLimit(weekSpendLimit.bidLong().longValue())
                                .withGoalId(goals[0])
                                .withBidCeiling(null)
                                .withAverageCpa(cpa.bidLong().longValue())))
                .withNetwork(new SmartCampaignNetworkStrategyMap().defaultServingOff());

    }

    @Test
    public void updateStrategyFromPayForConversionToAverageCpaTest() {
        UpdateResponse response = api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withSmartCampaign(new SmartCampaignUpdateItemMap()
                                .withBiddingStrategy(expectedStrategyMap))),
                ExpectedResult.success());
        assumeThat("получили результаты обновления кампании", response.getUpdateResults(), hasSize(1));

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(response.getUpdateResults().get(0).getId()))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withSmartCampaignFieldNames(SmartCampaignFieldEnum.BIDDING_STRATEGY));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        SmartCampaignStrategy actualStrategy = campaigns.get(0).getSmartCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        assertThat("получили корректные стратегии", actualStrategy,
                beanDifferV5((SmartCampaignStrategy) expectedStrategyMap.getBean()));
    }


}
