package ru.yandex.autotests.direct.api.campaigns.update.textcampaign;

import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.UpdateResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static org.hamcrest.core.Is.is;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка что ДРФ останется выключенными если сменить у кампании с включенными ДРФ стратегию на стратегию с остановленными показами на поиске и затем сменить стратегию обратно")
@Issue("https://st.yandex-team.ru/DIRECT-68661")
public class RelevantKeywordsNotSwitchedOnAfterToggleStrategyWithoutImressionsOnSearchTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;
    private static final int DEFAULT_BUDGET_PERCENT = 50;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long campaign;

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);

        campaign = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap().defaultCampaignAddItem().withTextCampaign(new TextCampaignAddItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap().defaultTextCampaignStrategy())
                        .withRelevantKeywords(
                                new RelevantKeywordsSettingAddMap().withBudgetPercent(DEFAULT_BUDGET_PERCENT))));

        UpdateResponse updateResponse = api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap().withId(campaign)
                        .withTextCampaign(new TextCampaignUpdateItemMap().withBiddingStrategy(
                                new TextCampaignStrategyMap()
                                        .withSearch(new TextCampaignSearchStrategyMap().defaultServingOff())
                                        .withNetwork(new TextCampaignNetworkStrategyMap()
                                                .defaultWbMaximumClicks(Currency.RUB))))),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.warningWithCode(10173))
                        .perl(ExpectedResult.warnings(new Notification(10173,
                                Api5ErrorDetails.RELEVANT_KEYWORDS_USELESS_FOR_CHOSEN_STRATEGY))));

        assumeThat("Обновлена текстовая кампания", updateResponse.getUpdateResults(), hasSize(1));

        List<CampaignGetItem> listOfCampaigngtItem = api.userSteps.campaignSteps().getCampaigns(new GetRequestMap()
                .withSelectionCriteria(new CampaignsSelectionCriteriaMap().withIds(campaign))
                .withFieldNames(CampaignFieldEnum.ID)
                .withTextCampaignFieldNames(TextCampaignFieldEnum.RELEVANT_KEYWORDS));

        assumeThat("Получена кампания", listOfCampaigngtItem, hasSize(1));
        assumeThat("Получена текстовая кампания", listOfCampaigngtItem.get(0).getTextCampaign(), notNullValue());
        assumeThat("ДРФ отключены", listOfCampaigngtItem.get(0).getTextCampaign().getRelevantKeywords().isNil(),
                is(true));
    }

    @Test
    public void relevantKeywordsNotSwitchedOnAfterChangingStrategy() {
        UpdateResponse updateResponse = api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap().withId(campaign)
                        .withTextCampaign(new TextCampaignUpdateItemMap().withBiddingStrategy(
                                new TextCampaignStrategyMap()
                                        .withSearch(new TextCampaignSearchStrategyMap().defaultHighestPosition())
                                        .withNetwork(new TextCampaignNetworkStrategyMap().defaultMaximumCoverage())))),
                ExpectedResult.success());

        assumeThat("Обновлена текстовая кампания", updateResponse.getUpdateResults(), hasSize(1));

        List<CampaignGetItem> listOfCampaigngtItem = api.userSteps.campaignSteps().getCampaigns(new GetRequestMap()
                .withSelectionCriteria(new CampaignsSelectionCriteriaMap().withIds(campaign))
                .withFieldNames(CampaignFieldEnum.ID)
                .withTextCampaignFieldNames(TextCampaignFieldEnum.RELEVANT_KEYWORDS));

        assumeThat("Получена кампания", listOfCampaigngtItem, hasSize(1));
        assumeThat("Получена текстовая кампания", listOfCampaigngtItem.get(0).getTextCampaign(), notNullValue());
        assertThat("ДРФ отключены", listOfCampaigngtItem.get(0).getTextCampaign().getRelevantKeywords().isNil(),
                is(true));
    }
}
