package ru.yandex.autotests.direct.api.campaigns.update.textcampaign;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.UpdateResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static org.hamcrest.core.Is.is;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка консистентности стратегии и настроек ДРФ")
@Issue("https://st.yandex-team.ru/DIRECT-68661")
@RunWith(Parameterized.class)
public class RelevantKeywordsSwitchedOffWhenInconsistentWithStrategyTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;
    private static final int DEFAULT_BUDGET_PERCENT = 50;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long campaign;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public String description;

    @Parameterized.Parameter(1)
    public TextCampaignAddItemMap textCampaignAddItemMap;

    @Parameterized.Parameter(2)
    public TextCampaignUpdateItemMap textCampaignUpdateItemMap;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"ДРФ выключится при установлении стратегии с остановленными показами на поиске",
                        new TextCampaignAddItemMap().withBiddingStrategy(
                                new TextCampaignStrategyAddMap().defaultTextCampaignStrategy()).withRelevantKeywords(
                                new RelevantKeywordsSettingAddMap().withBudgetPercent(DEFAULT_BUDGET_PERCENT)),
                        new TextCampaignUpdateItemMap().withBiddingStrategy(new TextCampaignStrategyMap()
                                .withSearch(new TextCampaignSearchStrategyMap().defaultServingOff())
                                .withNetwork(new TextCampaignNetworkStrategyMap().defaultWbMaximumClicks(Currency.RUB)))},
                {"ДРФ не включится при включении ДРФ у кампании со стратегией с остановленными показами на поиске",
                        new TextCampaignAddItemMap().withBiddingStrategy(new TextCampaignStrategyAddMap()
                                .withSearch(new TextCampaignSearchStrategyAddMap().defaultServingOff())
                                .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultWbMaximumClicks(Currency.RUB))),
                        new TextCampaignUpdateItemMap().withRelevantKeywords(
                                new RelevantKeywordsSettingMap().withBudgetPercent(DEFAULT_BUDGET_PERCENT))},
                {"ДРФ не включится при попытке включить ДРФ и сменить стратегию на стратегию с остановленными показами на поиске",
                        new TextCampaignAddItemMap().withBiddingStrategy(new TextCampaignStrategyAddMap().defaultTextCampaignStrategy()),
                        new TextCampaignUpdateItemMap().withBiddingStrategy(new TextCampaignStrategyMap()
                                .withSearch(new TextCampaignSearchStrategyMap().defaultServingOff())
                                .withNetwork(new TextCampaignNetworkStrategyMap().defaultWbMaximumClicks(Currency.RUB)))
                                .withRelevantKeywords(new RelevantKeywordsSettingMap().withBudgetPercent(DEFAULT_BUDGET_PERCENT))},
        });
    }

    @Before
    public void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);

        campaign = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap().defaultCampaignAddItem().withTextCampaign(textCampaignAddItemMap));
    }

    @Test
    public void relevantKeywordsSwitchedOff() {
        UpdateResponse updateResponse = api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap().withId(campaign).withTextCampaign(textCampaignUpdateItemMap)),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.warningWithCode(10173))
                        .perl(ExpectedResult.warnings(new Notification(10173,
                                Api5ErrorDetails.RELEVANT_KEYWORDS_USELESS_FOR_CHOSEN_STRATEGY))));

        assumeThat("Обновлена текстовая кампания", updateResponse.getUpdateResults(), hasSize(1));

        List<CampaignGetItem> listOfCampaigngtItem = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap().withIds(campaign))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.RELEVANT_KEYWORDS));

        assumeThat("Получена кампания", listOfCampaigngtItem, hasSize(1));
        assumeThat("Получена текстовая кампания", listOfCampaigngtItem.get(0).getTextCampaign(), notNullValue());
        assertThat("ДРФ отключены", listOfCampaigngtItem.get(0).getTextCampaign().getRelevantKeywords().isNil(),
                is(true));
    }
}
