package ru.yandex.autotests.direct.api.campaigns.update.textcampaign;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.beans.campaign.StrategyData;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStrategyName;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.api.campaigns.CampaignCommonMatchers.strategyDataCompareStrategy;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка обновления составных целей у стратегий в кампаниях")
@Issue("https://st.yandex-team.ru/DIRECT-142160")
@RunWith(Parameterized.class)
public class StepGoalUpdateTest {

    private static final int CPA_MULTIPLIER = 1000000;
    private static final String CLIENT = CampaignsLogins.CLIENT;
    private static final Integer COUNTER_ID = 31844711;
    private static final Currency CURRENCY = Currency.RUB;
    private static final Long AVERAGE_CPA = MoneyCurrency.get(CURRENCY).getMinAveragePrice().multiply(10).bidLong().longValue() / CPA_MULTIPLIER;

    private static int shard;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter()
    public String description;

    @Parameterized.Parameter(1)
    public Long goalId;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testData() {
        Object[][] data =  new Object[][] {
                {
                        "Сохранение кампании с подцелью составной цели",
                        19723215L
                },
                {
                        "Сохранение кампании с передачей составной цели по номеру",
                        19723210L
                }
        };
        return Arrays.asList(data);
    }


    @BeforeClass
    public static void initTest() {
        shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    public void updateCampaignWithStepGoalTest() {
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDefaultTextCampaign());

        TextCampaignUpdateItemMap textCampaignUpdateItemMap = new TextCampaignUpdateItemMap()
                        .withCounterIds(COUNTER_ID)
                        .withBiddingStrategy(new TextCampaignStrategyMap().defaultTextCampaignStrategy()
                                .withSearch(new TextCampaignSearchStrategyMap()
                                        .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_CPA)
                                        .withAverageCpa(new StrategyAverageCpaMap()
                                                .withAverageCpa(AVERAGE_CPA * CPA_MULTIPLIER)
                                                .withGoalId(goalId)))
                                .withNetwork(new TextCampaignNetworkStrategyMap().defaultServingOff())
                        );

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(cid)
                                .withTextCampaign(textCampaignUpdateItemMap)
                        ),
                ExpectedResult.success());

        CampaignsRecord actualCampaignsRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(cid);
        CampaignsRecord expectedCampaignsRecord = new CampaignsRecord();
        expectedCampaignsRecord.setCid(cid);
        expectedCampaignsRecord.setStrategyName(CampaignsStrategyName.autobudget_avg_cpa);
        expectedCampaignsRecord.setStrategyData(new StrategyData()
                .withPayForConversion(0)
                .withAvgCpa(AVERAGE_CPA.doubleValue())
                .withName(CampaignsStrategyName.autobudget_avg_cpa)
                .withGoalId(goalId.toString())
                .withVersion(1)
                .toJsonElement());

        assertThat("стратегия правильно обновилась в базе", actualCampaignsRecord.intoMap(),
                beanDifferV5(expectedCampaignsRecord.intoMap())
                        .useCompareStrategy(strategyDataCompareStrategy));
    }
}
