package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.fieldvalidation;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 28.01.16.
 * https://st.yandex-team.ru/TESTIRT-8330
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-49749")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка валидации Update поля RelevantKeywordsSetting (случаи когда Update работает как Add)")
@RunWith(Parameterized.class)
public class UpdateOptimizeGoalIdWithNoSettingsAddedTest {
    private static final Integer BUDGET_PERCENT = 100;

    private static String client = CampaignsLogins.UPDATE_CLIENT;

    private static Long linkedGoalId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);


    @Parameterized.Parameter(0)
    public RelevantKeywordsSettingMap relevantKeywordsParamsMap;

    @Parameterized.Parameter(1)
    public Long expectedGoalId;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {
                        new RelevantKeywordsSettingMap()
                                .withBudgetPercent(BUDGET_PERCENT)
                                .withOptimizeGoalId(0L),
                        0L
                },
                {
                        new RelevantKeywordsSettingMap()
                                .withBudgetPercent(BUDGET_PERCENT),
                        0L
                },
                {
                        new RelevantKeywordsSettingMap()
                                .withBudgetPercent(BUDGET_PERCENT)
                                .withOptimizeGoalId(null),
                        null
                },
                {
                        new RelevantKeywordsSettingMap()
                                .withBudgetPercent(BUDGET_PERCENT)
                                .withOptimizeGoalId(linkedGoalId),
                        linkedGoalId
                },

        });
    }

    private Long id;

    @BeforeClass
    public static void beforeClass() {
        linkedGoalId = (long) new MetrikaGoals().getNext();
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Before
    public void init() {
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .addCampMetrikaGoals(id, linkedGoalId, 100L, 100L);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1090")
    public void updateRelevantKeywordsSettingWithNoAdd() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withRelevantKeywords(relevantKeywordsParamsMap))
                        ),
                ExpectedResult.success());
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.RELEVANT_KEYWORDS));
        assumeThat("вернулась 1 кампания", getResponse.getCampaigns(), iterableWithSize(1));
        CampaignGetItem campaignGetItem = getResponse.getCampaigns().get(0);
        assertThat("поле RelevantKeywordsSetting сохранилось верно",
                campaignGetItem,
                beanDifferV5((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignGetItemMap()
                                        .withRelevantKeywords(relevantKeywordsParamsMap
                                                .withBudgetPercent(BUDGET_PERCENT)
                                                .withOptimizeGoalId(expectedGoalId))).getBean()));
    }
}
