package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.fieldvalidation;

import com.yandex.direct.api.v5.general.OperationEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.steps.CampaignsSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ArrayOfIntegerMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.api.campaigns.CampaignCommonMatchers.getMeaningfulGoalsJsonMatcher;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by liosha on 14.01.2019.
 * https://st.yandex-team.ru/DIRECT-76294
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-76294")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка перевалидации поля PriorityGoals")
public class UpdatePriorityGoalsNoRevalidation {

    private static String client = CampaignsLogins.UPDATE_CLIENT;
    private static final Integer COUNTER_ID = 34981090;
    private static final Long GOAL_ID = 17108070L;
    private static int shard;
    private static CampaignsSteps campaignJooqSteps;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void createCampaign() {
        shard = api.userSteps.clientFakeSteps().getUserShard(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignJooqSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps();
    }

    @Test
    public void updateDropCounterIdsSameGoalsNoRevalidation() {
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap().defaultTextCampaignStrategy())
                        .withCounterIds(COUNTER_ID)
                        .withPriorityGoals(new PriorityGoalsItemMap()
                                .withGoalId(GOAL_ID)
                                .withValue(1_000_000L))
                ));

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(cid)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withCounterIds((ArrayOfIntegerMap) null)
                                        .withPriorityGoals(new PriorityGoalsUpdateItemMap()
                                                .withGoalId(GOAL_ID)
                                                .withValue(1_000_000L)
                                                .withOperation(OperationEnum.SET)
                                        )
                                )
                        ),
                ExpectedResult.success());

        assertThat("meaningful_goals содержит правильный json",
                campaignJooqSteps.getCampOptionsById(cid).getMeaningfulGoals(),
                getMeaningfulGoalsJsonMatcher(GOAL_ID, 1L));
    }

    @Test
    public void updateDropCounterIdsNoRevalidation() {
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap().defaultTextCampaignStrategy())
                        .withCounterIds(COUNTER_ID)
                        .withPriorityGoals(new PriorityGoalsItemMap()
                                .withGoalId(GOAL_ID)
                                .withValue(1_000_000L))
                ));

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(cid)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withCounterIds((ArrayOfIntegerMap) null)
                                )
                        ),
                ExpectedResult.success());

        assertThat("meaningful_goals содержит правильный json",
                campaignJooqSteps.getCampOptionsById(cid).getMeaningfulGoals(),
                getMeaningfulGoalsJsonMatcher(GOAL_ID, 1L));
    }

}
