package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.fieldvalidation;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.RelevantKeywordsModeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingMap.BUDGET_PERCENT;
import static ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingMap.MAX_BUDGET_PERCENT;
import static ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingMap.MIN_BUDGET_PERCENT;

/**
 * Created by pavryabov on 17.09.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 * https://st.yandex-team.ru/TESTIRT-8645
 */
@Aqua.Test
@Issues({
        @Issue("https://st.yandex-team.ru/DIRECT-34570"),
        @Issue("https://st.yandex-team.ru/DIRECT-50424"),
})
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка обновления поля RelevantKeywordsSetting. Негативные сценарии")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateRelevantKeywordsSettingNegativeTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;

    private static Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public Integer budgetPercent;

    @Parameterized.Parameter(1)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "BudgetPercent = {0}")
    public static Collection testData() {
        JavaOrPerlExpectedResult expected = JavaOrPerlExpectedResult
                .java(ExpectedResult.errors(new Notification(5005,
                        Api5ErrorDetailsJava.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                        capitalize(BUDGET_PERCENT), MIN_BUDGET_PERCENT, MAX_BUDGET_PERCENT)))
                .perl(ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.BUDGET_EXPENDITURE_FOR_ADDITIONAL_RELEVANT_PHRASES_SPECIFIED_INCORRECTLY)));
        Object[][] data = new Object[][]{
                {-10, expected},
                {-1, expected},
                {0, expected},
                {110, expected},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1093")
    public void tryUpdateRelevantKeywordsSetting() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withRelevantKeywords(new RelevantKeywordsSettingMap()
                                                .withBudgetPercent(budgetPercent)
                                                .withMode(RelevantKeywordsModeEnum.OPTIMAL)))
                        ),
                expectedResult);
    }
}
