package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.fieldvalidation;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 17.09.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 * https://st.yandex-team.ru/TESTIRT-8645
 */
@Aqua.Test
@Issues({
        @Issue("https://st.yandex-team.ru/DIRECT-34570"),
        @Issue("https://st.yandex-team.ru/DIRECT-50424"),
})
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка обновления поля RelevantKeywordsSetting. Позитивные сценарии")
@RunWith(Parameterized.class)
public class UpdateRelevantKeywordsSettingPositiveTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;
    private static Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public Integer budgetPercent;

    @Parameterized.Parameter(1)
    public ProtocolType protocolType;

    @Parameterized.Parameters(name = "BudgetPercent = {0}, protocol = {1}")
    public static Collection<Object[]> data() throws UnsupportedEncodingException {
        return Arrays.asList(new Object[][]{
                {1, ProtocolType.JSON},
                {10, ProtocolType.JSON},
                {50, ProtocolType.JSON},
                {100, ProtocolType.JSON},
                {null, ProtocolType.JSON},
                {null, ProtocolType.SOAP}
        });
    }

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1094")
    public void updateRelevantKeywordsSetting() {
        api.protocol(protocolType);
        RelevantKeywordsSettingMap relevantKeywordsParamsMap = null;
        if (budgetPercent != null) {
            relevantKeywordsParamsMap = new RelevantKeywordsSettingMap()
                    .withBudgetPercent(budgetPercent);
        }
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withRelevantKeywords(relevantKeywordsParamsMap))
                        ),
                ExpectedResult.success());
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.RELEVANT_KEYWORDS));
        assumeThat("вернулась 1 кампания", getResponse.getCampaigns(), hasSize(1));
        CampaignGetItem campaignGetItem = getResponse.getCampaigns().get(0);
        assertThat("поле RelevantKeywordsSetting сохранилось верно",
                campaignGetItem,
                beanDifferV5((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignGetItemMap()
                                        .withRelevantKeywords(relevantKeywordsParamsMap == null
                                                ? relevantKeywordsParamsMap
                                                : relevantKeywordsParamsMap.withOptimizeGoalId(0L))
                                ).getBean()));
    }
}
