package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.fieldvalidation;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.UpdateResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 28.01.16.
 * https://st.yandex-team.ru/TESTIRT-8330
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-49749")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка обновления поля RelevantKeywordsSetting")
@Tag(TagDictionary.TRUNK)
public class UpdateRelevantKeywordsSettingTest {
    private static final RelevantKeywordsSettingAddMap RELEVANT_KEYWORDS_SETTING_ADD_MAP
            = new RelevantKeywordsSettingAddMap();
    private static final Integer INITIAL_BUDGET_PERCENT = 100;
    private static final Integer CHANGED_BUDGET_PERCENT = 50;
    private static String client = CampaignsLogins.UPDATE_CLIENT;
    private static Long ecommerceGoalId;
    private static Long goalId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void createCampaign() {
        goalId = MetrikaGoals.getGoalForLogin(client);
        ecommerceGoalId = 3088197432L;  // counterId = 88197432
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        RELEVANT_KEYWORDS_SETTING_ADD_MAP
                .withBudgetPercent(INITIAL_BUDGET_PERCENT)
                .withOptimizeGoalId(0L);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1095")
    public void updateRelevantKeywordsSettingAllFields() {
        Long id = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(
                        new TextCampaignAddItemMap()
                                .defaultTextCampaign()
                                .withRelevantKeywords(RELEVANT_KEYWORDS_SETTING_ADD_MAP)
                ), client);
        api.userSteps.campaignFakeSteps().setRandomOrderID(id);

        RelevantKeywordsSettingMap relevantKeywordsParamsMap = new RelevantKeywordsSettingMap()
                .withBudgetPercent(CHANGED_BUDGET_PERCENT)
                .withOptimizeGoalId(goalId);

        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campMetrikaGoalsSteps()
                .createCampMetrikaGoals(id, goalId, 100L, 100L);

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withRelevantKeywords(relevantKeywordsParamsMap))
                        ),
                ExpectedResult.success());

        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.RELEVANT_KEYWORDS));
        assumeThat("вернулась 1 кампания", getResponse.getCampaigns(), iterableWithSize(1));
        CampaignGetItem campaignGetItem = getResponse.getCampaigns().get(0);
        assertThat("поле RelevantKeywordsSetting сохранилось верно",
                campaignGetItem,
                beanDifferV5((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignGetItemMap()
                                        .withRelevantKeywords(relevantKeywordsParamsMap)).getBean()));
    }


    @Test
    public void updateRelevantKeywordsSettingWithEcommerceGoalId() {
        Long id = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(
                        new TextCampaignAddItemMap()
                                .defaultTextCampaign()
                                .withRelevantKeywords(RELEVANT_KEYWORDS_SETTING_ADD_MAP)
                ), client);
        api.userSteps.campaignFakeSteps().setRandomOrderID(id);

        RelevantKeywordsSettingMap relevantKeywordsParamsMap = new RelevantKeywordsSettingMap()
                .withBudgetPercent(CHANGED_BUDGET_PERCENT)
                .withOptimizeGoalId(ecommerceGoalId);

        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campMetrikaGoalsSteps()
                .createCampMetrikaGoals(id, ecommerceGoalId, 100L, 100L);

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withRelevantKeywords(relevantKeywordsParamsMap))
                        ),
                ExpectedResult.success());

        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.RELEVANT_KEYWORDS));
        assumeThat("вернулась 1 кампания", getResponse.getCampaigns(), iterableWithSize(1));
        CampaignGetItem campaignGetItem = getResponse.getCampaigns().get(0);
        assertThat("поле RelevantKeywordsSetting сохранилось верно",
                campaignGetItem,
                beanDifferV5((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignGetItemMap()
                                        .withRelevantKeywords(relevantKeywordsParamsMap)).getBean()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1097")
    public void updateRelevantKeywordsSettingBudgetPercentOnly() {
        Long id = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(
                        new TextCampaignAddItemMap()
                                .defaultTextCampaign()
                                .withRelevantKeywords(RELEVANT_KEYWORDS_SETTING_ADD_MAP)
                ));
        RelevantKeywordsSettingMap relevantKeywordsParamsMap = new RelevantKeywordsSettingMap()
                .withBudgetPercent(CHANGED_BUDGET_PERCENT);

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withRelevantKeywords(relevantKeywordsParamsMap))
                        ),
                ExpectedResult.success());

        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.RELEVANT_KEYWORDS));
        assumeThat("вернулась 1 кампания", getResponse.getCampaigns(), iterableWithSize(1));
        CampaignGetItem campaignGetItem = getResponse.getCampaigns().get(0);
        assertThat("поле RelevantKeywordsSetting сохранилось верно",
                campaignGetItem,
                beanDifferV5((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignGetItemMap()
                                        .withRelevantKeywords(
                                                relevantKeywordsParamsMap
                                                        .withOptimizeGoalId(0L)
                                        )).getBean()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1098")
    public void updateRelevantKeywordsSettingGoalIdOnly() {
        Long id = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(
                        new TextCampaignAddItemMap()
                                .defaultTextCampaign()
                                .withRelevantKeywords(RELEVANT_KEYWORDS_SETTING_ADD_MAP)
                ));
        api.userSteps.campaignFakeSteps().setRandomOrderID(id);
        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campMetrikaGoalsSteps()
                .createCampMetrikaGoals(id, goalId, 100L, 100L);
        RelevantKeywordsSettingMap relevantKeywordsParamsMap = new RelevantKeywordsSettingMap()
                .withOptimizeGoalId(goalId);

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withRelevantKeywords(relevantKeywordsParamsMap))
                        ),
                ExpectedResult.success());

        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.RELEVANT_KEYWORDS));
        assumeThat("вернулась 1 кампания", getResponse.getCampaigns(), iterableWithSize(1));
        CampaignGetItem campaignGetItem = getResponse.getCampaigns().get(0);
        assertThat("поле RelevantKeywordsSetting сохранилось верно",
                campaignGetItem,
                beanDifferV5((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignGetItemMap()
                                        .withRelevantKeywords(
                                                relevantKeywordsParamsMap
                                                        .withBudgetPercent(INITIAL_BUDGET_PERCENT)
                                        )).getBean()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1099")
    public void updateRelevantKeywordsSettingGoalIdNegative() {
        Long id = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(
                        new TextCampaignAddItemMap()
                                .defaultTextCampaign()
                                .withRelevantKeywords(RELEVANT_KEYWORDS_SETTING_ADD_MAP)
                ));
        RelevantKeywordsSettingMap relevantKeywordsParamsMap = new RelevantKeywordsSettingMap()
                .withOptimizeGoalId((-1) * goalId);

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withRelevantKeywords(relevantKeywordsParamsMap))
                        ),
                ExpectedResult.errors(new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER, capitalize(RelevantKeywordsSettingMap.OPTIMIZE_GOAL_ID))));

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1100")
    public void updateRelevantKeywordsSettingWithGoalIdNotAttached() {
        Long id = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(
                        new TextCampaignAddItemMap()
                                .defaultTextCampaign()
                                .withRelevantKeywords(RELEVANT_KEYWORDS_SETTING_ADD_MAP)
                ));
        RelevantKeywordsSettingMap relevantKeywordsParamsMap = new RelevantKeywordsSettingMap()
                .withOptimizeGoalId(goalId);

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withRelevantKeywords(relevantKeywordsParamsMap))
                        ),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(8800,
                                Api5ErrorDetailsJava.NOT_FOUND_PATH_AND_VALUE,
                                capitalize(RelevantKeywordsSettingMap.OPTIMIZE_GOAL_ID), goalId)))
                        .perl(ExpectedResult.errors(new Notification(8800,
                                Api5ErrorDetails.GOAL_ID_IN_FIELD_NOT_FOUND,
                                capitalize(RelevantKeywordsSettingMap.OPTIMIZE_GOAL_ID)))));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1101")
    public void updateRelevantKeywordsSettingSettingGoalIdToNull() {
        Long id = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(
                        new TextCampaignAddItemMap()
                                .defaultTextCampaign()
                                .withRelevantKeywords(RELEVANT_KEYWORDS_SETTING_ADD_MAP)
                ));

        RelevantKeywordsSettingMap relevantKeywordsParamsMap = new RelevantKeywordsSettingMap()
                .withOptimizeGoalId(null);

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withRelevantKeywords(relevantKeywordsParamsMap))
                        ),
                ExpectedResult.success());

        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.RELEVANT_KEYWORDS));
        assumeThat("вернулась 1 кампания", getResponse.getCampaigns(), iterableWithSize(1));
        CampaignGetItem campaignGetItem = getResponse.getCampaigns().get(0);
        assertThat("поле RelevantKeywordsSetting сохранилось верно",
                campaignGetItem,
                beanDifferV5((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignGetItemMap()
                                        .withRelevantKeywords(relevantKeywordsParamsMap
                                                .withBudgetPercent(INITIAL_BUDGET_PERCENT)
                                                .withOptimizeGoalId(null))).getBean()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1102")
    public void updateRelevantKeywordsSettingSettingGoalIdToZero() {
        Long id = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(
                        new TextCampaignAddItemMap()
                                .defaultTextCampaign()
                                .withRelevantKeywords(RELEVANT_KEYWORDS_SETTING_ADD_MAP.withOptimizeGoalId(null))
                ));

        RelevantKeywordsSettingMap relevantKeywordsParamsMap = new RelevantKeywordsSettingMap()
                .withOptimizeGoalId(0L);

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withRelevantKeywords(relevantKeywordsParamsMap))
                        ),
                ExpectedResult.success());

        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.RELEVANT_KEYWORDS));
        assumeThat("вернулась 1 кампания", getResponse.getCampaigns(), iterableWithSize(1));
        CampaignGetItem campaignGetItem = getResponse.getCampaigns().get(0);
        assertThat("поле RelevantKeywordsSetting сохранилось верно",
                campaignGetItem,
                beanDifferV5((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignGetItemMap()
                                        .withRelevantKeywords(relevantKeywordsParamsMap
                                                .withBudgetPercent(INITIAL_BUDGET_PERCENT)
                                                .withOptimizeGoalId(0L))).getBean()));
    }


    @Test
    public void updateRelevantKeywordsStrategyDependence() {
        TextCampaignStrategyAddMap strategyMap = new TextCampaignStrategyAddMap()
                .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage())
                .withSearch(new TextCampaignSearchStrategyAddMap().defaultServingOff());

        TextCampaignStrategyMap strategyUpdateMap = new TextCampaignStrategyMap()
                .withNetwork(new TextCampaignNetworkStrategyMap().defaultMaximumCoverage())
                .withSearch(new TextCampaignSearchStrategyMap().defaultHighestPosition());

        Long id = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap().defaultCampaignAddItem()
                .withTextCampaign(
                        new TextCampaignAddItemMap()
                                .defaultTextCampaign()
                                .withBiddingStrategy(strategyMap)));

        UpdateResponse res = api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withBiddingStrategy(strategyUpdateMap)
                                        .withRelevantKeywords(new RelevantKeywordsSettingMap()
                                                .withBudgetPercent(INITIAL_BUDGET_PERCENT)
                                                .withOptimizeGoalId(0L)
                                        )
                                )
                        ),
                ExpectedResult.success());
        assertThat("поле RelevantKeywordsSetting сохранилось верно", res.getUpdateResults(), iterableWithSize(1));

    }

}
