package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.fieldvalidation;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by buhter on 28.01.16.
 * https://st.yandex-team.ru/TESTIRT-8330
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-49749")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка валидации Update поля RelevantKeywordsSetting (случаи когда Update работает как Add)")
@RunWith(Parameterized.class)
public class UpdateRelevantKeywordsSettingWithNoSettingsAddedValidationTest {
    private static final Integer BUDGET_PERCENT = 100;

    private static String client = CampaignsLogins.UPDATE_CLIENT;

    private static Long goalId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);


    @Parameterized.Parameter(0)
    public RelevantKeywordsSettingMap relevantKeywordsParamsMap;

    @Parameterized.Parameter(1)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {
                        new RelevantKeywordsSettingMap(),
                        ExpectedResult.errors(new Notification(5000, Api5ErrorDetails.NO_VALUE_IN_FIELD, capitalize(RelevantKeywordsSettingMap.BUDGET_PERCENT)))
                },
                {
                        new RelevantKeywordsSettingMap().withOptimizeGoalId(goalId),
                        ExpectedResult.errors(new Notification(5000, Api5ErrorDetails.NO_VALUE_IN_FIELD, capitalize(RelevantKeywordsSettingMap.BUDGET_PERCENT)))
                },
                {
                        new RelevantKeywordsSettingMap().withBudgetPercent(BUDGET_PERCENT).withOptimizeGoalId(
                                (long) -1),
                        ExpectedResult.errors(new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER, capitalize(RelevantKeywordsSettingMap.OPTIMIZE_GOAL_ID)))
                },
                {
                        new RelevantKeywordsSettingMap().withBudgetPercent(BUDGET_PERCENT).withOptimizeGoalId(goalId),
                        ExpectedResult.success()
                },

        });
    }

    private Long id;

    @BeforeClass
    public static void beforeClass() {
        goalId = (long) new MetrikaGoals().getNext();
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Before
    public void init() {
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .addCampMetrikaGoals(id, goalId, 100L, 100L);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1103")
    public void updateRelevantKeywordsSettingWithNoAdd() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withRelevantKeywords(relevantKeywordsParamsMap))
                        ),
                expectedResult);
    }
}
