package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.settings;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.general.AttributionModelEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.db.steps.JooqCampaignsOpts;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumConversionRateMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Campaigns.CAMPAIGNS;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;


@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("При обновлении кампании через api меняется флаг IsSimplifiedStrategyView")
@Issue("https://st.yandex-team.ru/DIRECT-116714")
@RunWith(Parameterized.class)
public class IsSimplifiedStrategyViewOnCampaignTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;
    private static final List<Long> GOAL_IDS = MetrikaGoals.getGoalsForLogin(CLIENT, 2);

    private static final String FLAG_NAME = "is_simplified_strategy_view_enabled";
    private static final long DEFAULT_WEEKLY_SPEND_LIMIT = 300_000_000L;
    public static final long CHANGED_WEEKLY_SPEND_LIMIT = 400_000_000L;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public TextCampaignUpdateItemMap campaignUpdateItemMap;

    @Parameterized.Parameter(value = 2)
    public Boolean expectedFlag;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {
                        "Смена только недельного бюджета",
                        new TextCampaignUpdateItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyMap()
                                .withSearch(
                                        new TextCampaignSearchStrategyMap()
                                                .defaultServingOff())
                                .withNetwork(
                                        new TextCampaignNetworkStrategyMap()
                                                .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum
                                                        .WB_MAXIMUM_CONVERSION_RATE)
                                                .withWbMaximumConversionRate((new StrategyMaximumConversionRateMap())
                                                        .defaultMaximumConversionRateParams(Currency.RUB)
                                                        .withWeeklySpendLimit(CHANGED_WEEKLY_SPEND_LIMIT)
                                                        .withGoalId(GOAL_IDS.get(0))))),
                        true
                },
                {
                        "Смена только цели",
                        new TextCampaignUpdateItemMap()
                                .withBiddingStrategy(
                                new TextCampaignStrategyMap()
                                        .withSearch(
                                                new TextCampaignSearchStrategyMap()
                                                        .defaultServingOff())
                                        .withNetwork(
                                                new TextCampaignNetworkStrategyMap()
                                                        .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum
                                                                .WB_MAXIMUM_CONVERSION_RATE)
                                                        .withWbMaximumConversionRate((new
                                                                StrategyMaximumConversionRateMap())
                                                                .defaultMaximumConversionRateParams(Currency.RUB)
                                                                .withWeeklySpendLimit(DEFAULT_WEEKLY_SPEND_LIMIT)
                                                                .withGoalId(GOAL_IDS.get(1))))),
                        true
                },
                {
                        "Смена площадки для показов на только поиск",
                        new TextCampaignUpdateItemMap()
                                .withBiddingStrategy(
                                new TextCampaignStrategyMap()
                                        .withSearch(
                                                new TextCampaignSearchStrategyMap()
                                                        .defaultWbMaximumConversionRate(Currency.RUB,
                                                                GOAL_IDS.get(1)))
                                        .withNetwork(
                                                new TextCampaignNetworkStrategyMap()
                                                        .defaultServingOff())),
                        true
                },
                {
                        "Смена площадки для показов на BOTH",
                        new TextCampaignUpdateItemMap().withBiddingStrategy(
                                new TextCampaignStrategyMap()
                                        .withSearch(new TextCampaignSearchStrategyMap()
                                                .defaultWbMaximumConversionRate(Currency.RUB, GOAL_IDS.get(1)))
                                        .withNetwork(new TextCampaignNetworkStrategyMap().defaultNetworkDefault())),
                        true
                },
                {
                        "Смена площадки для показов на BOTH и установка максимальной цены клика",
                        new TextCampaignUpdateItemMap().withBiddingStrategy(
                                new TextCampaignStrategyMap()
                                        .withSearch(new TextCampaignSearchStrategyMap()
                                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE)
                                                .withWbMaximumConversionRate(new StrategyMaximumConversionRateMap()
                                                        .defaultMaximumConversionRateParams(Currency.RUB)
                                                        .withGoalId(GOAL_IDS.get(1))
                                                        .withBidCeiling(100_000_000L)))
                                        .withNetwork(new TextCampaignNetworkStrategyMap().defaultNetworkDefault())),
                        false
                },
                {
                        "Смена модели атрибуции",
                        new TextCampaignUpdateItemMap()
                                .withAttributionModel(AttributionModelEnum.FC)
                                .withBiddingStrategy(new TextCampaignStrategyMap()
                                .withSearch(
                                        new TextCampaignSearchStrategyMap()
                                                .defaultServingOff())
                                .withNetwork(
                                        new TextCampaignNetworkStrategyMap()
                                                .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum
                                                        .WB_MAXIMUM_CONVERSION_RATE)
                                                .withWbMaximumConversionRate((new StrategyMaximumConversionRateMap())
                                                        .defaultMaximumConversionRateParams(Currency.RUB)
                                                        .withWeeklySpendLimit(CHANGED_WEEKLY_SPEND_LIMIT)
                                                        .withGoalId(GOAL_IDS.get(0))))),
                        false
                },
                {
                        "Смена типа стратегии",
                        new TextCampaignUpdateItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyMap()
                                .withSearch(
                                        new TextCampaignSearchStrategyMap()
                                                .defaultServingOff())
                                .withNetwork(
                                        new TextCampaignNetworkStrategyMap()
                                                .defaultMaximumCoverage())),
                        false
                },
                {
                        "Установка максимальной цены клика",
                        new TextCampaignUpdateItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyMap()
                                .withSearch(
                                        new TextCampaignSearchStrategyMap()
                                                .defaultServingOff())
                                .withNetwork(
                                        new TextCampaignNetworkStrategyMap()
                                                .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum
                                                        .WB_MAXIMUM_CONVERSION_RATE)
                                                .withWbMaximumConversionRate((new StrategyMaximumConversionRateMap())
                                                        .defaultMaximumConversionRateParams(Currency.RUB)
                                                        .withBidCeiling(100_000_000L)
                                                        .withWeeklySpendLimit(DEFAULT_WEEKLY_SPEND_LIMIT)
                                                        .withGoalId((GOAL_IDS.get(0)))))),
                        false
                },
        };
        return Arrays.asList(data);
    }

    private Long campaignId;

    @Before
    public void before() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        long goalIdFirst = GOAL_IDS.get(0);
        long goalIdSecond = GOAL_IDS.get(1);
        jooqDbSteps.campaignsSteps()
                .addCampMetrikaGoals(campaignId, goalIdFirst, 10L, 100L);
        jooqDbSteps.campaignsSteps()
                .addCampMetrikaGoals(campaignId, goalIdSecond, 10L, 100L);
        TextCampaignStrategyMap strategyMap = new TextCampaignStrategyMap()
                .withSearch(new TextCampaignSearchStrategyMap().defaultServingOff())
                .withNetwork(new TextCampaignNetworkStrategyMap().defaultWbMaximumConversionRate(Currency.RUB,
                        goalIdFirst));
        api.userSteps.campaignSteps().campaignsUpdateWithCheck(new CampaignUpdateItemMap()
                .withId(campaignId)
                .withTextCampaign(new TextCampaignUpdateItemMap()
                        .withBiddingStrategy(strategyMap)));

        List<JooqCampaignsOpts> flags =
                Collections.singletonList(JooqCampaignsOpts.IS_SIMPLIFIED_STRATEGY_VIEW_ENABLED);
        jooqDbSteps.campaignsSteps().setOpts(campaignId, flags);
    }

    @Test
    public void campaignsUpdate() {
        api.userSteps.campaignSteps().campaignsUpdateWithCheck(
                new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withTextCampaign(campaignUpdateItemMap));

        String campaignOpts = (String) jooqDbSteps.campaignsSteps().getCampaignOption(campaignId, CAMPAIGNS.OPTS);
        assertThat("вернулся ожидаемый набор настроек", campaignOpts.contains(FLAG_NAME), equalTo(expectedFlag));
    }

}
