package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.settings;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Arrays.asList;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Campaigns.CAMPAIGNS;
import static ru.yandex.autotests.direct.db.steps.JooqCampaignsOpts.PRICE_RECOMMENDATIONS_MANAGEMENT_ENABLED;
import static ru.yandex.autotests.direct.db.steps.JooqCampaignsOpts.RECOMMENDATIONS_MANAGEMENT_ENABLED;

@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("При обновлении кампании через api не падаем при наличии флагов recommendations_management_enabled price_recommendations_management_enabled")
@Issue("https://st.yandex-team.ru/DIRECT-163392")
public class RecommendationsManagementOnCampaignTest {
    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);

    private Long campaignId;

    @Before
    public void before() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
    }

    @Test
    public void updateWithRecommendationsManagementEnabled() {
        jooqDbSteps.campaignsSteps().setOpts(campaignId, asList(RECOMMENDATIONS_MANAGEMENT_ENABLED));

        api.userSteps.campaignSteps().campaignsUpdateWithCheck(new CampaignUpdateItemMap()
                .withId(campaignId)
                .withTextCampaign(new TextCampaignUpdateItemMap()));

        String campaignOpts = (String) jooqDbSteps.campaignsSteps().getCampaignOption(campaignId, CAMPAIGNS.OPTS);
        assertThat("Опции соответствуют ожиданиям", campaignOpts, equalTo("recommendations_management_enabled"));
    }

    @Test
    public void updateWithPriceRecommendationsManagementEnabled() {
        jooqDbSteps.campaignsSteps().setOpts(campaignId, asList(PRICE_RECOMMENDATIONS_MANAGEMENT_ENABLED));

        api.userSteps.campaignSteps().campaignsUpdateWithCheck(new CampaignUpdateItemMap()
                .withId(campaignId)
                .withTextCampaign(new TextCampaignUpdateItemMap()));

        String campaignOpts = (String) jooqDbSteps.campaignsSteps().getCampaignOption(campaignId, CAMPAIGNS.OPTS);
        assertThat("Опции соответствуют ожиданиям", campaignOpts, equalTo("price_recommendations_management_enabled"));
    }
}
