package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.settings;

import java.util.Arrays;
import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.jooq.TableField;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsAutooptimization;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusbehavior;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.Tables.CAMP_OPTIONS;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Campaigns.CAMPAIGNS;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка не поддерживаемых значений поля Settings в текстовых кампаниях")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
@ParametersAreNonnullByDefault
public class UpdateDeprecatedSettingTest {
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static final String LOGIN = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    private static Long campaignId;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public TextCampaignSettingsEnum option;

    @Parameterized.Parameter(1)
    public YesNoEnum value;

    @Parameterized.Parameter(2)
    public TableField optionInDB;

    @Parameterized.Parameter(3)
    public Object valueInDB;

    @Parameterized.Parameters(name = "option = {0}, value = {1} in DB = {3}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                // DIRECT-63109
                {TextCampaignSettingsEnum.ENABLE_RELATED_KEYWORDS, YesNoEnum.NO,
                        CAMP_OPTIONS.IS_RELATED_KEYWORDS_ENABLED, 1},
                {TextCampaignSettingsEnum.ENABLE_RELATED_KEYWORDS, YesNoEnum.YES,
                        CAMP_OPTIONS.IS_RELATED_KEYWORDS_ENABLED, 1},
                {TextCampaignSettingsEnum.ENABLE_RELATED_KEYWORDS, YesNoEnum.NO,
                        CAMP_OPTIONS.IS_RELATED_KEYWORDS_ENABLED, 0},
                {TextCampaignSettingsEnum.ENABLE_RELATED_KEYWORDS, YesNoEnum.YES,
                        CAMP_OPTIONS.IS_RELATED_KEYWORDS_ENABLED, 0},
                // DIRECT-68434
                {TextCampaignSettingsEnum.ENABLE_AUTOFOCUS, YesNoEnum.NO,
                        CAMPAIGNS.AUTOOPTIMIZATION, CampaignsAutooptimization.Yes},
                {TextCampaignSettingsEnum.ENABLE_AUTOFOCUS, YesNoEnum.YES,
                        CAMPAIGNS.AUTOOPTIMIZATION, CampaignsAutooptimization.Yes},
                // DIRECT-69528
                {TextCampaignSettingsEnum.ENABLE_BEHAVIORAL_TARGETING, YesNoEnum.NO,
                        CAMPAIGNS.STATUSBEHAVIOR, CampaignsStatusbehavior.Yes},
                {TextCampaignSettingsEnum.ENABLE_BEHAVIORAL_TARGETING, YesNoEnum.YES,
                        CAMPAIGNS.STATUSBEHAVIOR, CampaignsStatusbehavior.Yes},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void prepareCampaign() {
        campaignId = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withTextCampaign(
                                new TextCampaignAddItemMap()
                                        .defaultTextCampaign()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("146")
    public void checkSettingsTest() {
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).campaignsSteps()
                .setCampaignOption(campaignId, optionInDB, valueInDB);

        api.userSteps.campaignSteps().shouldGetResultOn(
                Action.UPDATE,
                new UpdateRequestMap().withCampaigns(
                        new CampaignUpdateItemMap()
                                .withId(campaignId)
                                .withTextCampaign(
                                        new TextCampaignUpdateItemMap()
                                                .withSettings(new TextCampaignSettingMap()
                                                        .withOption(option)
                                                        .withValue(value)))),
                ExpectedResult.warnings(new Notification(10163, Api5ErrorDetails.CAMPAIGN_SETTING_DEPRECATED, option)));

        Object resultValue =
                api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).campaignsSteps()
                        .getCampaignOption(campaignId,optionInDB);
        assertThat("значение настройки не изменилось", resultValue, equalTo(valueInDB));
    }
}
