package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.settings;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampOptionsRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.upperCase;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 14.06.16.
 * https://st.yandex-team.ru/TESTIRT-9494
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-53323")
@Features(CampaignsFeatures.UPDATE)
@Description("Создание и обновление кампании с различными значениями ENABLE_SITE_MONITORING " +
        "и проверка значения camp_options.statusMetricaControl")
@RunWith(Parameterized.class)
public class UpdateEnableSiteMonitoringAndCheckDbTest {
    private static final String CLIENT_BS = CampaignsLogins.CLIENT_FOR_BS_MONITORING;

    private static Long campaignId;
    private static int shard;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String client;

    @Parameterized.Parameter(1)
    public YesNoEnum settingValue;

    @Parameterized.Parameters(name = "client = {0}, value = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {CLIENT_BS, YesNoEnum.NO},
                {CLIENT_BS, YesNoEnum.YES},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void prepareCampaign() {
        api.as(client);
        shard = api.userSteps.clientFakeSteps().getUserShard(client);
        List<Long> ids = api.userSteps.campaignSteps().campaignsAddWithCheck(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withTextCampaign(new TextCampaignAddItemMap()
                                .defaultTextCampaign()
                                .withSettings(new TextCampaignSettingMap()
                                        .withOption(TextCampaignSettingsEnum.ENABLE_SITE_MONITORING)
                                        .withValue(settingValue))));
        assumeThat("создана кампания", ids, hasSize(1));
        campaignId = ids.get(0);

        CampOptionsRecord campOptions = api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .getCampOptionsById(campaignId);

        assumeThat("camp_options.statusMetricaControl имеет правильное значение",
                upperCase(campOptions.getStatusmetricacontrol().toString()),
                equalTo(settingValue.toString()));
        api.userSteps.campaignSteps().campaignsUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                .withSettings(new TextCampaignSettingMap()
                                        .withOption(TextCampaignSettingsEnum.ENABLE_SITE_MONITORING)
                                        .withValue(settingValue)))));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1113")
    public void settingValueTest() {
        CampOptionsRecord campOptions = api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .getCampOptionsById(campaignId);
        assertThat("camp_options.statusMetricaControl имеет правильное значение",
                upperCase(campOptions.getStatusmetricacontrol().toString()),
                equalTo(settingValue.toString()));
    }
}
