package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.settings;

import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 02.10.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка предупреждения при попытке перевода кампании самостоятельного клиента на сервисируемость")
public class UpdateManagerAssistanceForSelfclientTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());
    public static final String client = CampaignsLogins.GET_CLIENT;
    private Long campaignID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    @Step("Подготовим данные для теста")
    public void prepareCampaign() {
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeCampaignModerated(campaignID);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1115")
    public void noServingForSelfclientTest() {
        log.info("Обновим значение настройки REQUIRE_SERVICING на Yes");
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(
                        new CampaignUpdateItemMap()
                                .withId(campaignID)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withSettings(new TextCampaignSettingMap()
                                                .withOption(TextCampaignSettingsEnum.REQUIRE_SERVICING)
                                                .withValue(YesNoEnum.YES)))),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.warnings(campaignID, new Notification(10163,
                                Api5ErrorDetailsJava.CAMPAIGN_WILL_NOT_BE_SENT_TO_SERVING)))
                        .perl(ExpectedResult.warnings(campaignID, new Notification(10163,
                                Api5ErrorDetails.CAMPAIGN_WILL_NOT_BE_SENT_TO_SERVING)))
        );
    }
}
