package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerPhraseFakeInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.CampaignFakeInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 16.09.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Поверка StatusBsSynced после обновления стратегии с автоматической на ручную")
@Issue("https://st.yandex-team.ru/DIRECT-34570")
@RunWith(Parameterized.class)
public class CheckStatusBsSyncedAfterUpdateStrategyFromAutoToManualTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long id;
    private Long adGroupId;
    private Long adId;
    private Long keywordId;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public TextCampaignSearchStrategyAddMap searchStrategyForCreate;

    @Parameterized.Parameter(2)
    public TextCampaignNetworkStrategyAddMap networkStrategyForCreate;

    @Parameterized.Parameter(3)
    public TextCampaignSearchStrategyMap searchStrategyForUpdate;

    @Parameterized.Parameter(4)
    public TextCampaignNetworkStrategyMap networkStrategyForUpdate;

    @Parameterized.Parameter(5)
    public String expectedBidsStatusBsSynced;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Авто + ShowsDisabled -> Ручная + Ручная",
                        new TextCampaignSearchStrategyAddMap().defaultWbMaximumClicks(Currency.RUB),
                        new TextCampaignNetworkStrategyAddMap().defaultServingOff(),
                        new TextCampaignSearchStrategyMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyMap().defaultMaximumCoverage(),
                        Value.NO},
                {"Авто + ShowsDisabled -> ShowsDisabled + Ручная",
                        new TextCampaignSearchStrategyAddMap().defaultWbMaximumClicks(Currency.RUB),
                        new TextCampaignNetworkStrategyAddMap().defaultServingOff(),
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().defaultMaximumCoverage(),
                        Value.NO},
                {"Авто + ShowsDisabled -> Ручная + ShowsDisabled",
                        new TextCampaignSearchStrategyAddMap().defaultWbMaximumClicks(Currency.RUB),
                        new TextCampaignNetworkStrategyAddMap().defaultServingOff(),
                        new TextCampaignSearchStrategyMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyMap().defaultServingOff(),
                        Value.NO},
                {"ShowsDisabled + Авто -> Ручная + Ручная",
                        new TextCampaignSearchStrategyAddMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyAddMap().defaultWbMaximumClicks(Currency.RUB),
                        new TextCampaignSearchStrategyMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyMap().defaultMaximumCoverage(),
                        Value.NO},
                {"ShowsDisabled + Авто -> ShowsDisabled + Ручная",
                        new TextCampaignSearchStrategyAddMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyAddMap().defaultWbMaximumClicks(Currency.RUB),
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().defaultMaximumCoverage(),
                        Value.NO},
                {"ShowsDisabled + Авто -> Ручная + ShowsDisabled",
                        new TextCampaignSearchStrategyAddMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyAddMap().defaultWbMaximumClicks(Currency.RUB),
                        new TextCampaignSearchStrategyMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyMap().defaultServingOff(),
                        Value.NO}
        });
    }

    @BeforeClass
    public static void prepareClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Before
    public void createCampaign() {
        id = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                .withSearch(searchStrategyForCreate)
                                .withNetwork(networkStrategyForCreate))));
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(id);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);

        api.userSteps.campaignFakeSteps().setBSSynced(id, true);
        api.userSteps.campaignFakeSteps().setStatusModerate(id, Status.YES);
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        assumeThat("у кампании StatusBsSynced = Yes", campaignFakeInfo.getStatusBsSynced(), equalTo(Value.YES));
        assumeThat("у кампании StatusModerate = Yes", campaignFakeInfo.getStatusModerate(), equalTo(Status.YES));

        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(adGroupId, Value.YES);
        GroupFakeInfo groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupId);
        assumeThat("у группы StatusBsSynced = Yes", groupFakeInfo.getStatusBsSynced(), equalTo(Value.YES));

        api.userSteps.bannersFakeSteps().setStatusBsSynced(adId, Value.YES);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assumeThat("у объявления StatusBsSynced = Yes", bannerFakeInfo.getStatusBsSynced(), equalTo(Value.YES));

        api.userSteps.phrasesFakeSteps().setStatusBsSynced(keywordId, Value.YES);
        BannerPhraseFakeInfo bannerPhraseFakeInfo =
                api.userSteps.phrasesFakeSteps().getBannerPhraseParams(keywordId);
        assumeThat("у фразы StatusBsSynced = Yes", bannerPhraseFakeInfo.getStatusBsSynced(), equalTo(Value.YES));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1119")
    public void updateStrategy() {
        //DIRECT-46406
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withBiddingStrategy(new TextCampaignStrategyMap()
                                                .withSearch(searchStrategyForUpdate)
                                                .withNetwork(networkStrategyForUpdate)))
                        ),
                ExpectedResult.success(id));
        checkStatuses(Value.NO, Value.YES, Value.YES, expectedBidsStatusBsSynced);
    }

    public void checkStatuses(String campaignStatus, String adGroupStatus, String adStatus, String keywordStatus) {
        List<String> statuses = new ArrayList<String>();
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        statuses.add(campaignFakeInfo.getStatusBsSynced());
        GroupFakeInfo groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupId);
        statuses.add(groupFakeInfo.getStatusBsSynced());
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        statuses.add(bannerFakeInfo.getStatusBsSynced());
        BannerPhraseFakeInfo bannerPhraseFakeInfo =
                api.userSteps.phrasesFakeSteps().getBannerPhraseParams(keywordId);
        statuses.add(bannerPhraseFakeInfo.getStatusBsSynced());
        assertThat("объекты имеют правильные статусы (campaign, adGroup, ad, keyword)",
                statuses, equalTo(Arrays.asList(campaignStatus, adGroupStatus, adStatus, keywordStatus)));
    }
}
