package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.strategy;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignStrategy;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageRoiMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 30.08.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Позитивные сценарии создания текстовой кампании с автоматическими стратегиями для Network")
@Tag(TagDictionary.TRUNK)
public class StrategyCombinationsAutoNetworkTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static TextCampaignStrategyMap strategyMap;
    private static TextCampaignStrategyMap expectedStrategyMap;
    private static final Integer counterId = MetrikaGoals.getCounterForLogin(client);
    private static final Long goalId = MetrikaGoals.getGoalForCounter(counterId);
    private Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public TextCampaignNetworkStrategyMap networkStrategy;

    @Parameterized.Parameter(value = 2)
    public TextCampaignNetworkStrategyMap expectedNetworkStrategy;

    @Parameterized.Parameters(name = "strategy = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                //DIRECT-45818
                {"AverageCpc",
                        new TextCampaignNetworkStrategyMap().defaultAverageCpc(currency),
                        new TextCampaignNetworkStrategyMap().defaultAverageCpc(currency)},
                {"MaximumClicks",
                        new TextCampaignNetworkStrategyMap().defaultWbMaximumClicks(currency),
                        new TextCampaignNetworkStrategyMap().defaultWbMaximumClicks(currency)},
                {"AverageRoi",
                        new TextCampaignNetworkStrategyMap().defaultAverageRoi(goalId),
                        new TextCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.AVERAGE_ROI)
                                .withAverageRoi(new StrategyAverageRoiMap()
                                .defaultStrategyAverageRoi()
                                .withGoalId(goalId)
                                .withProfitability(null)
                                .withWeeklySpendLimit(null)
                                .withBidCeiling(null))},
                {"AverageCpa",
                        new TextCampaignNetworkStrategyMap().defaultAverageCpa(currency, goalId),
                        new TextCampaignNetworkStrategyMap().defaultAverageCpa(currency, goalId)},
                {"MaximumConversionRate",
                        new TextCampaignNetworkStrategyMap().defaultWbMaximumConversionRate(currency, goalId),
                        new TextCampaignNetworkStrategyMap().defaultWbMaximumConversionRate(currency, goalId)}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                .withSearch(new TextCampaignSearchStrategyAddMap().defaultServingOff())
                                .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage()))));

        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .addCampMetrikaGoals(campaignId, goalId.longValue(), 100L, 100L);

        strategyMap = new TextCampaignStrategyMap()
                .withNetwork(networkStrategy);
        expectedStrategyMap = new TextCampaignStrategyMap()
                .withSearch(new TextCampaignSearchStrategyMap().defaultServingOff())
                .withNetwork(expectedNetworkStrategy);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1122")
    public void strategyNetworkTest() {
        api.userSteps.campaignSteps().campaignsUpdateWithCheck(new CampaignUpdateItemMap()
                .withId(campaignId)
                .withTextCampaign(new TextCampaignUpdateItemMap()
                        .withBiddingStrategy(strategyMap)));

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.BIDDING_STRATEGY));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        TextCampaignStrategy actualStrategy = campaigns.get(0).getTextCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        assertThat("получили корректные стратегии", actualStrategy,
                beanDifferV5((TextCampaignStrategy) expectedStrategyMap.getBean()));
    }
}
