package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.strategy;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignStrategy;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyNetworkDefaultAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyNetworkDefaultMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 28.08.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Обновление текстовой кампании с ручными стратегиями для Search и допустимыми комбинациями стратегий для" +
        " Network")
@Tag(TagDictionary.TRUNK)
public class StrategyCombinationsManualSearchTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public TextCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameter(value = 2)
    public TextCampaignNetworkStrategyMap networkStrategy;

    @Parameterized.Parameter(value = 3)
    public TextCampaignSearchStrategyAddMap searchStrategyAdd;

    @Parameterized.Parameter(value = 4)
    public TextCampaignNetworkStrategyAddMap networkStrategyAdd;

    @Parameterized.Parameters(name = "Strategy = {0}")
    public static Collection roles() {
        Object[][] data = new Object[][]{
                {"HighestPosition + MaximumCoverage",
                        new TextCampaignSearchStrategyMap()
                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION),
                        new TextCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE),
                        new TextCampaignSearchStrategyAddMap()
                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION),
                        new TextCampaignNetworkStrategyAddMap()
                                .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE)},
                {"HighestPosition + ServingOff",
                        new TextCampaignSearchStrategyMap()
                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION),
                        new TextCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.SERVING_OFF),
                        new TextCampaignSearchStrategyAddMap()
                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION),
                        new TextCampaignNetworkStrategyAddMap()
                                .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.SERVING_OFF)},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1124")
    public void updateCampaignStrategyTest() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .defaultCampaignUpdateItem()
                        .withId(campaignId)
                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyMap()
                                        .withSearch(searchStrategy)
                                        .withNetwork(networkStrategy)))),
                ExpectedResult.success(campaignId));

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.BIDDING_STRATEGY));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        TextCampaignStrategy actualStrategy = campaigns.get(0).getTextCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        TextCampaignStrategyMap expectedStrategy = new TextCampaignStrategyMap()
                .withSearch(searchStrategy)
                .withNetwork(networkStrategy);

        assertThat("получили корректные стратегии", actualStrategy,
                beanDifferV5((TextCampaignStrategy) expectedStrategy.getBean()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1125")
    public void updateToAutoStrategyTest() {
        //DIRECT-46187
        List<Long> ids = api.userSteps.campaignSteps().campaignsAddWithCheck(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                .withSearch(searchStrategyAdd)
                                .withNetwork(networkStrategyAdd))));
        assumeThat("создана кампания", ids, hasSize(1));

        log.info("Изменим стратегию кампании на автобюджетную");
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .defaultCampaignUpdateItem()
                        .withId(ids.get(0))
                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyMap()
                                        .withSearch(new TextCampaignSearchStrategyMap().defaultAverageCpc(currency))
                                        .withNetwork(new TextCampaignNetworkStrategyMap().defaultNetworkDefault())))),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.success())
                        .perl(ExpectedResult.warnings(
                                new Notification(10165, Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED, capitalize(
                                        StrategyNetworkDefaultAddMap.LIMIT_PERCENT)),
                                new Notification(10163, Api5ErrorDetails.SETTING_WILL_NOT_BE_CHANGED,
                                        TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC)))
        );

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(ids.get(0)))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.BIDDING_STRATEGY));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        TextCampaignStrategy actualStrategy = campaigns.get(0).getTextCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        TextCampaignStrategyMap expectedStrategy = new TextCampaignStrategyMap()
                .withSearch(new TextCampaignSearchStrategyMap().defaultAverageCpc(currency))
                .withNetwork(new TextCampaignNetworkStrategyMap()
                        .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT));

        assertThat("стратегия изменена на автобюджетную", actualStrategy,
                beanDifferV5((TextCampaignStrategy) expectedStrategy.getBean()));
    }
}
